import logging
import json
import simplejson
from django.http import Http404
#from django.http import HttpResponseRedirect
from django.contrib.auth import logout
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth import authenticate
from django.contrib.auth import login
from django.http import HttpResponseRedirect, HttpResponse
from django.contrib.auth.decorators import login_required
from controller.Searcher import Searcher
from controller.ClusterAnnotation import ClusterAnnotation
from controller.DocumentAnnotation import DocumentAnnotation
from controller.DocumentaryFile import DocumentaryFile
from controller.Documents import Documents 
from controller.DocumentaryFiles import DocumentaryFiles
from controller.Clusters import Clusters
from controller.DocumentaryFileAnnotation import DocumentaryFileAnnotation
from dataparser.ClientSearchAttributes import ClientSearchAttributes
from document.models import Documentaryfile
from django.core.urlresolvers import reverse
from mediapartdb.MediapartReader import MediapartReader

logger = logging.getLogger('document')

def article(request,cluster_title, id_article):
	logger.info('article called'+str(request))
	logger.info('article called'+str(id_article))
	reader = MediapartReader()
	url = reader.get_url(str(id_article))
	logger.info('url'+str(url))
	my_data_dictionary = {'url_article': url, 'cluster_title': cluster_title}
	
	my_data_dictionary['dossierDocs'] = []

	
	dossierDoc = []
	if request.user.is_authenticated():
		logger.info('user')
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			logger.info('lengthdocumentaryFiles = '+str(len(documentaryFiles)))
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url, 'id':str(docfile.id)})
			logger.info('dossierDoc = '+str(dossierDoc))
			my_data_dictionary['dossierDocs'].append(dossierDoc)
	return render_to_response('article.html', my_data_dictionary, context_instance=RequestContext(request))


def login_view(request):
	logger.info('login_view called!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!')
	logger.info('login_view session_items ********** ='+str(request.session.items()))
	username = request.POST['username']
	logger.info('username = '+username)
	password = request.POST['password']
		
	user = authenticate(username=username, password=password)
	request.session['user'] = username  
	my_data_dictionary = {'loginstatus': ''}
	my_data_dictionary['dossierDocs'] = []
	
	if user is not None:
		if user.is_active:
			login(request, user)
			dossierDoc = []
			documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
			if documentaryFiles:
				for docfile in documentaryFiles:
					dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url})
				
				my_data_dictionary['dossierDocs'].append(dossierDoc)
				request.session['dossierDocs'] = dossierDoc
			logger.info(my_data_dictionary['dossierDocs'])
			logger.info('user logged')
		else:
			logger.info('user not active')
			logger.onfo('user not active')
			my_data_dictionary['loginstatus'] = 'Utilisateur inactif'
	else:
		logger.info('invalid user')
		logger.info('invalid user')
		my_data_dictionary['loginstatus'] = 'Idenfiant ou mot de passe incorrect'
	
	request.session['refreshOnly'] = True
	return HttpResponseRedirect(request.GET.get('next', '/')) 


def logout_view(request):
	"""
	Logout users out and re-direct them to the main page.
	"""
	query_id = request.session['query_id']
	key1 = request.session['key1']
	jsonStreamgraph = request.session['jsonStreamgraph']
	jsonTreemap = request.session['jsonTreemap']

	logout(request)
	request.session['refreshOnly'] = True
	request.session['query_id'] = query_id
	request.session['key1'] = key1
	request.session['jsonStreamgraph'] = jsonStreamgraph
	request.session['jsonTreemap'] = jsonTreemap
	logger.info('query_context4 ********** ='+str(request.session.items()))
	return HttpResponseRedirect(request.GET.get('next', '/')) 

def documentary_file_user_update(request):
	logger.info('documentary_file_user_update')
	myjson = {'user': request.user.username}
	myjson['dossierDocs'] = []
	if request.user.is_authenticated():
		logger.info('documentary_file_user_update is_authenticated')
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			for docfile in documentaryFiles:
				logger.info('docfile.title = '+str(docfile.title))
				dossierDoc = {'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url, 'id':docfile.id}
				myjson['dossierDocs'].append(dossierDoc)
	else:
		logger.info('documentary_file_user_update not is_authenticated')	
	json = simplejson.dumps(myjson)
	return HttpResponse(json)


def document_main_page(request,query=0,cluster=0,offset=0,count=0,docId=0):
	logger.info('document_main_page called'+str(request))
	logger.info('document_main_page session_items1 ********** ='+str(request.session.items()))
	my_data_dictionary = {'user': request.user}
	my_data_dictionary['dossierDocs'] = []
	my_data_dictionary['mydossierDoc'] = ''
	
	dossierDoc = []
	if request.user.is_authenticated():
		logger.info('user')
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			logger.info('lengthdocumentaryFiles = '+str(len(documentaryFiles)))
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url, 'id':str(docfile.id)})
			logger.info('dossierDoc = '+str(dossierDoc))
			my_data_dictionary['dossierDocs'].append(dossierDoc)
						
	if request.is_ajax():
		logger.info('is_ajax')
		requestType = request.POST['requestType']
		
		if requestType == "streamgraph":
			logger.info('streamgraph')
			if request.session['refreshOnly'] == False:
				request.session['from_date'] = request.POST['from_date']
				request.session['to_date'] = request.POST['to_date']
				request.session['category']= request.POST.getlist('categories')
			searcher = Searcher(request);
			'''attr = ClientSearchAttributes(request)
			key1 = attr.get_hash_value_from_text_image()
			query_id = attr.get_hash_value()
			request.session['query_id'] = int(query_id)
			request.session['key1'] = int(key1)'''
			json = searcher.streamgraph()
			logger.info('document_main_page session_items2********** ='+str(request.session.items()))
			return HttpResponse(json)
		elif requestType == "treemap":
			logger.info('treemap')
			attr = ClientSearchAttributes(request)
			'''key1 = attr.get_hash_value_from_text_image()
			query_id = attr.get_hash_value()
			request.session['query_id'] = int(query_id)
			request.session['key1'] = int(key1)'''
			if request.session['refreshOnly'] == False:
				request.session['from_date'] = request.POST['from_date']
				request.session['to_date'] = request.POST['to_date']
				request.session['category']= request.POST.getlist('categories')

			searcher = Searcher(request);
			json = searcher.treemap()
			request.session['json'] = json
			logger.info('document_main_page session_items3 ********** ='+str(request.session.items()))
			return HttpResponse(json)
		elif requestType == "treemapUpdate":
			logger.info('treemapUpdate')
			return render_to_response('index.html', my_data_dictionary, context_instance=RequestContext(request))
		elif requestType == "setAffichage":
			logger.info('setAffichage'+str(request.POST['typeTri']))
			request.session['typeTri'] = request.POST['typeTri']
			logger.info('jsontremap1*******'+str(request.session['jsonTreemap']))
			myjsonTreemap = simplejson.loads(request.session['jsonTreemap'])
			logger.info('myjsonTreemap*******'+str(myjsonTreemap['query']['typeTri']))
			myjsonTreemap['query']['typeTri'] = request.POST['typeTri']
			request.session['jsonTreemap'] = simplejson.dumps(myjsonTreemap)
			logger.info('jsontremap2*******'+str(request.session['jsonTreemap']))
			json = {'ok':'ok'}
			return HttpResponse(json)
		'''elif requestType == "documents":
			logger.info('documents'+str(query))
			logger.info('documents'+str(cluster))
			logger.info('documents'+str(offset))
			logger.info('documents'+str(count))
			documents = Documents(request)
			jsondocuments = documents.get_documents(query,cluster,offset,count)
			request.session['jsondocuments'] = jsondocuments
			return render_to_response('cluster.html',my_data_dictionary, context_instance=RequestContext(request))'''
			#return HttpResponse(jsondocuments)
	else:
		logger.info('is_not_ajax')
		if query != 0 or docId != 0:
			documents = Documents(request)
			jsondocuments = documents.get_documents(query,cluster,offset,count,docId)
			request.session['jsondocuments'] = jsondocuments
			return render_to_response('cluster.html',my_data_dictionary, context_instance=RequestContext(request))
		else:
			try:
				filtre = request.POST['filtre']
				if filtre == "nok":
					logger.info('filtre * == '+filtre)
					#if requestType == "streamgraph":
					searcher = Searcher(request)
					attr = ClientSearchAttributes(request)
					key1 = attr.get_hash_value_from_text_image()
					query_id = attr.get_hash_value()
					request.session['query_id'] = int(query_id)
					request.session['key1'] = int(key1)
					jsonstream = searcher.streamgraph()
					
						#return HttpResponse(json)
					#elif requestType == "treemap":
						#logger.info('treemap')
						#if request.session['refreshOnly'] == False and id==0:
					if request.session['refreshOnly'] == False:
						request.session['from_date'] = request.POST['from_date']
						request.session['to_date'] = request.POST['to_date']
						request.session['category']= request.POST.getlist('categories')
		
					searcher = Searcher(request)
					jsontreemap = searcher.treemap()
					#request.session['json'] = json
					logger.info('refreshnok ********** ='+str(request.session.items()))
				elif  filtre == "ok":
					logger.info('filtre ! == '+filtre)
					searcher = Searcher(request)
					jsonstream = searcher.streamgraph()
					jsontreemap = searcher.treemap()
			except Exception, err:
				logger.info('exception')
				try:
					if request.session['refreshOnly'] == True:
						logger.info('refreshOnly TRUE')
						request.session['refreshOnly'] = False
						return render_to_response('index.html', my_data_dictionary, context_instance=RequestContext(request))
				except Exception, err:
					request.session['refreshOnly'] = False
					request.session['jsonStreamgraph'] = {}
					request.session['jsonTreemap'] = {}
					request.session['json2'] = {}
					request.session['json'] = {}
					request.session['query_id_treemap'] = ''
					request.session['query_id_streamgraph'] = ''
					request.session['query_id'] = ''
					request.session['key1'] = ''
					request.session['from_date'] = ''
					request.session['to_date'] = ''
					request.session['category'] = []
					request.session['typeTri'] = 'treemap'
					request.session['jsontreemapdossierdoc'] = ''
					request.session['jsonstreamgraphdossierdoc'] = ''
					logger.info('session id==0 ********** ='+str(request.session.items()))
			return render_to_response('index.html', my_data_dictionary, context_instance=RequestContext(request))
		'''else:
			logger.info("id !=0")
			documentaryFile = Documentaryfile.objects.get(id=id)
			request.session['jsontreemap'] = documentaryFile.jsontreemap
			request.session['jsonstreamgraph'] = documentaryFile.jsonstreamgraph
			my_data_dictionary['mydossierDoc'] = {'dossierDocTitle':documentaryFile.title}
			logger.info('my_data_dictionary = '+str(my_data_dictionary))
			return render_to_response('index-dossier.html',my_data_dictionary, context_instance=RequestContext(request))'''

def get_mesdossiersDoc(request):
	logger.info('get_mesdossiersDoc called')
	my_data_dictionary = {'user': request.user}
	my_data_dictionary['loginstatus'] = ''
	my_data_dictionary['myDocumentaryFiles'] = ''
	logger.info('get_mesdossiersDoc called2')
	if not request.user.is_authenticated():
		logger.info('Anonymous user')
		return render_to_response('index.html', my_data_dictionary, context_instance=RequestContext(request))
	else:
		logger.info('user'+str(request.user))
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			my_data_dictionary['myDocumentaryFiles'] = '<section id="dossierDoc"><h1>Mes dossiers docs</h1>'
			for docfile in documentaryFiles:
				logger.info('docfile.image.url = '+docfile.image.url)
				my_data_dictionary['myDocumentaryFiles'] += '<article style="width:278px">'
				#my_data_dictionary['myDocumentaryFiles'] += '<img src="{{ STATIC_URL }}images/'
				my_data_dictionary['myDocumentaryFiles'] += '<img src="'
				my_data_dictionary['myDocumentaryFiles'] += docfile.image.url
				my_data_dictionary['myDocumentaryFiles'] += '" style="height:29px;width:50px;float:left;padding-right:10px"/> <h2 style="float:left">'
				my_data_dictionary['myDocumentaryFiles'] += docfile.title
				my_data_dictionary['myDocumentaryFiles'] += '</h2><br><p>'
				my_data_dictionary['myDocumentaryFiles'] += docfile.description
				my_data_dictionary['myDocumentaryFiles'] += '</p></article>'

	# get user information here (documentary file ...)
	
	#
	return render_to_response('mesdossiersDoc.html', my_data_dictionary, context_instance=RequestContext(request))

	
'''def streamgraph(request):
	print 'streamgraph'
	if request.method == 'POST':
		print 'POST'
		searcher = Searcher(request);
		json = searcher.streamgraph()
		return HttpResponse(json)
	else:
		print 'ERROR'
		raise Http404
	return HttpResponse("OK")'''

def streamgraph(request):
	logger.info('streamgraph !!!! ')
	my_data_dictionary = {'user': request.user}
	searcher = Searcher(request);
	jsonStreamgraph = searcher.streamgraph()
	logger.info('jsonStreamgraph ====='+jsonStreamgraph)
	request.session['jsonStreamgraph'] = jsonStreamgraph
	'''return HttpResponse(json)'''
	

	if request.is_ajax():
		print("is_ajax")
		return HttpResponse(json)
	else:
		print("isnot_ajax")
		return render_to_response('recherche.html',my_data_dictionary, context_instance=RequestContext(request))

def treemap(request):
	logger.info( 'TREEMAP ENTER !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!')
	logger.info('query_context1 ********** ='+str(request.session.items()))
	if request.session['refreshOnly'] == False:
		logger.info( 'TREEMAP ENTER refreshOnly FALSE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!')
		request.session['from_date'] = request.POST['from_date']
		request.session['to_date'] = request.POST['to_date']
		request.session['category']= request.POST.getlist('categories')
		
	my_data_dictionary = {'user': request.user}
	my_data_dictionary['dossierDocs'] = []
	dossierDoc = []
	if request.user.is_authenticated():
		print request.user.is_authenticated()
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url})
			print dossierDoc
			my_data_dictionary['dossierDocs'].append(dossierDoc)
			logger.info(my_data_dictionary['dossierDocs'])
	
	searcher = Searcher(request);
	json = searcher.treemap()
	request.session['json'] = json
	if request.is_ajax():
		print("is_ajax")
		return HttpResponse(json)
	else:
		print("isnot_ajax")
		return render_to_response('recherche.html',my_data_dictionary, context_instance=RequestContext(request))


def get_documents_with_annotations(request,query=0,cluster=0,offset=0,count=0,docId=0):
	logger.info('get_documents_with_annotations !!!!!!!!'+str(request))
	
	'''if request.method == 'GET':'''
	if  request.method == 'GET' and request.session['refreshOnly'] == True:
		logger.info("get_request and refresh")
		json2 = request.session['json2']
		request.session['refreshOnly'] = False
	else:
		logger.info("NOT get_request and refresh")
		documents = Documents(request)
		json2 = documents.get_documents(query,cluster,offset,count)
		request.session['json2'] = json2
				
	d = json.loads(json2)
	my_data_dictionary = {'cluster_title': d['cluster_title']}
	my_data_dictionary['dossierDocs'] = []
	dossierDoc = []
	
	if request.user.is_authenticated():
		print request.user.is_authenticated()
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url})
			print dossierDoc
			my_data_dictionary['dossierDocs'].append(dossierDoc)
			logger.info(my_data_dictionary['dossierDocs'])
	if request.is_ajax():
		logger.info("is_ajax")
		return HttpResponse(json2)
	else:
		logger.info("is_not_ajax")
		return render_to_response('cluster.html',my_data_dictionary, context_instance=RequestContext(request))
	'''return HttpResponse(json)'''
	
	'''else:
		raise Http404'''
	
def get_annotations(request):
	if request.method == 'GET':
		print 'get_annotations'
		annotations = DocumentAnnotation(request);
		json = annotations.get_annotations()
		return HttpResponse(json)
	else:
		raise Http404	


def get_documentary_file(request,myuser="", cluster=0,offset=0,count=0, docId=0):
	logger.info('get_documentary_file docId'+str(docId))
	logger.info('get_documentary_file cluster'+str(cluster))

	my_data_dictionary = {'user': request.user}
	my_data_dictionary['dossierDocs'] = []

	
	dossierDoc = []
	if request.user.is_authenticated():
		logger.info('user')
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			logger.info('lengthdocumentaryFiles = '+str(len(documentaryFiles)))
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url, 'id':str(docfile.id)})
			logger.info('dossierDoc = '+str(dossierDoc))
			my_data_dictionary['dossierDocs'].append(dossierDoc)
	
	documentaryFile = Documentaryfile.objects.get(id=docId)
	request.session['jsontreemapdossierdoc'] = documentaryFile.jsontreemap
	request.session['jsonstreamgraphdossierdoc'] = documentaryFile.jsonstreamgraph
	my_data_dictionary['mydossierDoc'] = {'dossierDocTitle':documentaryFile.title}
		
	if int(count) != 0:
		logger.info('get_documentary_file docId != 0')
		documents = Documents(request)
		jsondocuments = documents.get_documents(0,cluster,offset,count,docId)
		request.session['jsondocuments'] = jsondocuments
		return render_to_response('clusterDoc.html',my_data_dictionary, context_instance=RequestContext(request))
	else:		
		logger.info('my_data_dictionary = '+str(request.session['jsontreemapdossierdoc']))
		logger.info('my_data_dictionary = '+str(request.session['jsonstreamgraphdossierdoc']))
		return render_to_response('index-dossier.html',my_data_dictionary, context_instance=RequestContext(request))
		
		
	'''if request.user.is_authenticated():
		logger.info(request.user.is_authenticated())
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url, 'id':docfile.id})
			logger.info('dossierDoc = '+str(dossierDoc))
			my_data_dictionary['dossierDocs'].append(dossierDoc)
			logger.info(my_data_dictionary['dossierDocs'])
	return render_to_response('index-dossier.html',my_data_dictionary, context_instance=RequestContext(request))'''

#@login_required
def documentary_files(request,myuser=""):
	logger.info('documentary_files'+str(request.user))
	doc_files = DocumentaryFiles(request);
	json = doc_files.get_files(myuser,'0','12')
	request.session['json3'] = json
	
	my_data_dictionary = {}
	my_data_dictionary['dossierDocs'] = []
	dossierDoc = []

	if request.user.is_authenticated():
		logger.info(request.user.is_authenticated())
		documentaryFiles = Documentaryfile.objects.filter(user=request.user.id)
		if documentaryFiles:
			for docfile in documentaryFiles:
				dossierDoc.append({'title':docfile.title, 'description':docfile.description, 'url':docfile.image.url, 'id':docfile.id})
			logger.info('dossierDoc = '+str(dossierDoc))
			my_data_dictionary['dossierDocs'].append(dossierDoc)
			logger.info(my_data_dictionary['dossierDocs'])
			
	return render_to_response('dossiersdocumentaire.html',my_data_dictionary, context_instance=RequestContext(request)) 
	
		
def documentary_file_visibility(request):
	if request.method == 'POST':
		print 'documentary_file_visibility'
		documentary_file = DocumentaryFile(request);
		json = documentary_file.visibilityChange()		
		return HttpResponse(json)
	else:
		raise Http404
	return HttpResponse("OK")

def documentary_file_delete(request,docId=0):
	logger.info('isajax ???'+str(request.is_ajax()))	
	if request.method == 'POST':
		logger.info('documentary_file_delete = '+str(docId))
		documentaryfile_var = DocumentaryFile(request);
		json = documentaryfile_var.delete(docId)	
		logger.info('NEXT ====='+str(request.GET.get('next', '/')))
		return HttpResponseRedirect(request.GET.get('next', '/')) 		
		#return HttpResponse(json)
	else:
		raise Http404
	#return HttpResponse("OK")

def documentary_file_create(request):
	logger.info('documentary_file_create = '+str(request))
	logger.info('documentary_file_create session_items ********** ='+str(request.session.items()))
	if not request.user.is_authenticated():
		logger.info('Anonymous user')
		myjson = {'user':'Vous devez vous connecter.'}
		json = simplejson.dumps(myjson)
	else:
		if request.method == 'POST':
			logger.info('documentary_file create')
			documentary_file = DocumentaryFile(request);
			json = documentary_file.create()
		else:
			raise Http404
		return HttpResponse("OK")
	return HttpResponse(json)

def cluster_annotation_create(request):
	if request.method == 'POST':
		logger.info('cluster annotation create')
		clusterAnnotation_var = ClusterAnnotation(request);
		json = clusterAnnotation_var.create()
					
		return HttpResponse(json)
	else:
		raise Http404
	return HttpResponse("OK")

def cluster_annotation_delete(request):
	if request.method == 'POST':
		logger.info('cluster annotation delete')
		clusterAnnotation_var = ClusterAnnotation(request);
		json = clusterAnnotation_var.delete()
					
		return HttpResponse(json)
	else:
		raise Http404
	return HttpResponse("OK")

def document_annotation_create(request):
	if request.method == 'POST':
		logger.info('document annotation create')
		document_annotation = DocumentAnnotation(request);
		json = document_annotation.create()
					
		return HttpResponse(json)
	else:
		raise Http404
	return HttpResponse("OK")

def document_annotation_delete(request):
	if request.method == 'POST':
		logger.info('document annotation delete')
		document_annotation = DocumentAnnotation(request);
		json = document_annotation.delete()
					
		return HttpResponse(json)
	else:
		raise Http404
	return HttpResponse("OK")

def get_clusters(request):
	if request.method == 'GET':
		logger.info('get clusters of a documentary file')
		clusters = Clusters(request);
		json = clusters.get_treemap_of_clusters()
					
		return HttpResponse(json)
	else:
		raise Http404

def create_annotation_on_documentary_file(request):
	if request.method == 'POST':
		logger.info('create an annotation on a documentary file')
		annotation = DocumentaryFileAnnotation(request);
		json = annotation.create()
					
		return HttpResponse(json)
	else:
		raise Http404
	
def delete_annotation_on_documentary_file(request):
	if request.method == 'POST':
		logger.info('delete an annotation on a documentary file')
		annotation = DocumentaryFileAnnotation(request);
		json = annotation.delete()
					
		return HttpResponse(json)
	else:
		raise Http404