'''
Created on 07 Aout 2012

@author: Corinne
'''

import logging

from dataparser.ClientClusterAnnotationDeleteAttributes import ClientClusterAnnotationDeleteAttributes
from dataparser.ClientClusterAnnotationCreateAttributes import ClientDocumentAnnotationCreateAttributes
from document.models import Cluster
from django.contrib.auth.models import User
from document.models import Tag
from document.models import Documentaryfile
from document.models import Annotationcluster

logger = logging.getLogger('document')

class ClusterAnnotation(object):

    def __init__(self, request):
        logger.info('ClusterAnnotation init')
        self.request = request
           
    def create(self):
        logger.info('create ClusterAnnotation')
        attr = ClientDocumentAnnotationCreateAttributes(self.request)
        logger.info('get_user = ' + str(attr.get_user()))
        logger.info('get_documentary_file = ' + str(attr.get_documentary_file()))
        logger.info('get_annotation = ' + str(attr.get_annotation()))
        logger.info('get_cluster = ' + str(attr.get_cluster()))
        logger.info('get_tags = ' + str(attr.get_tags()))
        tags_attr = attr.get_tags()
        try:
            cluster = Cluster.objects.get(pk=attr.get_cluster())
            try:
                user_attr = User.objects.get(username=attr.get_user)
            except User.DoesNotExist:
                json= '{"error": "User does not existed"}'
                logger.info(json)
                return json
            
            try:
                annotationCluster = Annotationcluster.objects.create(description=attr.get_annotation(),user=user_attr, cluster=cluster)
            except Exception:
                json = '{"error": "cluster_id already exists"}'
                logger.info(json)
                return json     
                 
            if tags_attr: 
                logger.info('tags associated to annotation')
                for tag in tags_attr:
                    logger.info('annotation_tag = '+str(tag))
                    for tag in tags_attr:
                        logger.info('annotation_tag = '+str(tag))
                        tag_attr = Tag(value=tag,annotationcluster=annotationCluster)
                        tag_attr.save()
                              
            json = '{"annotation_cluster_created":' + str(annotationCluster.id) + '}'
            logger.info(json)
        except Cluster.DoesNotExist:
            json = '{"error": "Invalid cluster id"}'
            logger.info(json)
            return json
        
        return json

    def delete(self):
        logger.info('delete ClusterAnnotation')
        attr = ClientClusterAnnotationDeleteAttributes(self.request)
        logger.info('get_user = ' + str(attr.get_user()))
        logger.info('get_documentary_file_id = ' + str(attr.get_documentary_file()))
        logger.info('get_cluster = ' + str(attr.get_cluster()))
        clusterId = attr.get_cluster()
        
        if clusterId=='':
            json = '{"error": "No cluster_id attribute in the http post request"}'
            logger.info(json)
            return json
        try:
            cluster = Cluster.objects.get(pk=clusterId)
            try:
                annotationcluster = cluster.annotationcluster
            except cluster.annotationcluster.DoesNotExist:
                json= '{"error": "No annotation on this cluster"}'
                logger.info(json)
                return json
                
        except Cluster.DoesNotExist:
            json = '{"error": "Invalid cluster id"}'
            logger.info(json)
            return json
        
        try:
            documentaryfile = Documentaryfile.objects.get(pk=attr.get_documentary_file())
        except Documentaryfile.DoesNotExist:
            json = '{"error": "Invalid documentary_file_id"}'
            logger.info(json)
            return json
        
        logger.info('documentaryfile.user.name = ' + str(documentaryfile.user.username))
        if documentaryfile.user.username == attr.get_user():
            annotationcluster.delete()
            json = '{"annotation_cluster_deleted" :'  + str(clusterId) + '}'
            logger.info(json)
        else:
            json = '{"error": "User does not matched"}'
            logger.info(json)
       
        return json