/* Génération de données aléatoires */

var data = [],
    startcolor = [ 0, 0, 255 ],
    endcolor = [ 255, 255, 0 ]
    elementcount = 8;

for (var i = 0; i < elementcount; i++) {
    var r = i/elementcount,
        col = _(endcolor).map(function(e,i) {
            var s = startcolor[i]
            return Math.floor(r*e + (1-r)*s)
        });
    data.push({
        label: "Cluster " + (1+i),
        i: i+1,
        color: "rgb("+col.join(",")+")",
        value: 1+Math.pow(Math.random(),2)*5
    });
}

/* Génération du Treemap */

data = _(data).sortBy(function(d) { return -d.value; });

var IDEALRATIO = 1.25;

function cuttree(data, x, y, w, h, cut, ratio, callback) {
    
    function f(subdata, subx, suby, subw, subh) {
        if (subdata.length == 1) {
            subdata[0].x = subx;
            subdata[0].y = suby;
            subdata[0].w = subw;
            subdata[0].h = subh;
        } else {
            callback(subdata, subx, suby, subw, subh)
        }
    }
    
    var first = _(data).first(cut), rest = _(data).rest(cut);
    if (!first.length || !rest.length) {
        return;
    }
    if (w/h > IDEALRATIO) {
        var leftw = w * ratio;
        f(first, x, y, leftw, h);
        f(rest, x + leftw, y, w - leftw, h);
    } else {
        var toph = h * ratio;
        f(first, x, y, w, toph);
        f(rest, x, y + toph, w, h - toph);
    }
}

function pivot(data, x, y, w, h) {
    var cut = 1, cumul = 0, bestcumul = 0, total = _(data).reduce(function(a,b){return a+b.value},0), bestcut = Infinity;
    for (var i = 0; i < data.length - 1; i++) {
        cumul += data[i].value;
        var delta = Math.abs(cumul - total/2);
        if (delta < bestcut) {
            bestcut = delta;
            bestcumul = cumul;
            cut = i+1;
        } else {
            break;
        }
    }
    cuttree(data, x, y, w, h, cut, bestcumul / total, pivot);
}

function squarify(data, x, y, w, h) {
    var cut = 1, cumul = 0, bestcumul = 0, total = _(data).reduce(function(a,b){return a+b.value},0), bestcut = Infinity;
    for (var i = 0; i < data.length - 1; i++) {
        cumul += data[i].value;
        cuttree(data, x, y, w, h, i+1, cumul / total, pivot);
        var ratio = Math.abs(Math.log(IDEALRATIO*data[0].h/data[0].w));
        if (ratio < bestcut) {
            bestcut = ratio;
            bestcumul = cumul;
            cut = i+1;
        } else {
            break;
        }
    }
    cuttree(data, x, y, w, h, cut, bestcumul / total, squarify);
}

/* Template des éléments à insérer */
var actu = 
    '<div class="actu" style="left: <%=x%>px; top: <%=y%>px; width: <%=w%>px; height: <%=h%>px; background: <%=color%>">'+
        '<a href="#">'+
            '<img src="img/home-visuel-<%-i%>.jpg" alt="" />'+
        '</a>'+
        '<div class="inner-actu">'+
            '<h2><a href="#"><%-label%></a></h2>'+
            '<div class="links">'+
                '<ul>'+
                    '<li><a href="#" title="Supprimer le cluster" class="trash"></a></li>'+
                    '<li><a href="#" title="317 Annotations sur ce cluster" class="file"><span>317</span></a></li>'+
                    '<li><a href="#" title="Ajouter une annotation au cluster" class="comment"></a></li>'+
                '</ul>'+
            '</div>'+
        '</div>'+
    '</div>';
var tmpl = _.template(actu);

squarify(data,0,0,760,358);

document.getElementById('treemap1').innerHTML = _(data).reduce(function(mem, d) {
    return mem + tmpl(d);
},"");

//redimensionnement d'image
$(".actu").each(function(k,v){
    var wActu = $(this).width();
    var hActu = $(this).height();
    var img = $(this).find('img');
    var wImg = img.width();
    var hImg = img.height();

    var ratioImg = wImg/hImg;
    img.css('height',hActu);
    img.css('width',hActu*ratioImg);
    wImg = img.width();
    hImg = img.height();

    if(wActu>wImg){
        var ratioImg = hImg/wImg;
        img.css('width', wActu);
        img.css('height',wActu*ratioImg);
        wImg = img.width();
        hImg = img.height();
    }

    if (wImg<wActu) {
        img.css('margin-left',(wActu-wImg)/2);
    }else{
        img.css('margin-left',-(wImg-wActu)/2);
    }
    if (hImg<hActu) {
        img.css('margin-top',(hActu-hImg)/2);
    }else{
        img.css('margin-top',-(hImg-hActu)/2);
    }
});