'''
Created on 10 Aout. 2012

@author: Gerard
'''

import logging

from dataparser.DocumentaryFileAnnotationAttributes import DocumentaryFileAnnotationCreateAttributes
from dataparser.DocumentaryFileAnnotationDeleteAttributes import DocumentaryFileAnnotationDeleteAttributes
from django.contrib.auth.models import User
from document.models import Documentaryfile
from document.models import AnnotationDocumentaryFile

logger = logging.getLogger('document')

class DocumentaryFileAnnotation(object):

    def __init__(self, request):
        self.request = request
           
    def create(self):
        attr = DocumentaryFileAnnotationCreateAttributes(self.request)
        
        if attr.get_documentary_file_id() == '':
            json = '{"error": "No documentary_file_id attribute in the http post request"}'
            logger.info(json)
            return json
        
        if attr.get_user()=='':
            json = '{"error": "No user attribute in the http post request"}'
            logger.info(json)
            return json
        
        try:
            user = User.objects.get(username=attr.get_user())
        except User.DoesNotExist:
            json = '{"error": "Invalid User Id"}'
            logger.info(json)
            return json
        
        try:
            docFile = Documentaryfile.objects.get(id=attr.get_documentary_file_id(), user_id=user.id)
        except Documentaryfile.DoesNotExist:
            json = '{"error": "Invalid DocumentaryFile Id"}'
            logger.info(json)
            return json
        
        try:
            annotation = AnnotationDocumentaryFile.objects.get(documentaryFile=docFile)
            annotation.description = attr.get_annotation()
            annotation.save(force_update=True)
        except AnnotationDocumentaryFile.DoesNotExist:
            annotation = AnnotationDocumentaryFile(description=attr.get_annotation(), user=user, documentaryFile=docFile)
            annotation.save()
        
        json = '{"annotation_documentary_file_created":' + str(annotation.id) + '}'
        logger.info(json)
        return json
            
    def delete(self):
        attr = DocumentaryFileAnnotationDeleteAttributes(self.request)
        
        if attr.get_documentary_file_id() == '':
            json = '{"error": "No documentary_file_id attribute in the http post request"}'
            logger.info(json)
            return json
                    
        if attr.get_user() == '':
            json = '{"error": "No user attribute in the http post request"}'
            logger.info(json)
            return json
               
        if attr.get_annotation_id() == '':
            json = '{"error": "No annotation_id attribute in the http post request"}'
            logger.info(json)
            return json
                    
        try:
            user = User.objects.get(username=attr.get_user())
        except User.DoesNotExist:
            json = '{"error": "Invalid User Id"}'
            logger.info(json)
            return json
                  
        try:
            docFile = Documentaryfile.objects.get(id=attr.get_documentary_file_id(), user_id=user.id)
        except Documentaryfile.DoesNotExist:
            json = '{"error": "Invalid documentary file id"}'
            logger.info(json)
            return json
             
        anotationDocumentaryFileId= attr.get_annotation_id()
        try:
            anotationDocumentaryFile = AnnotationDocumentaryFile.objects.get(pk=anotationDocumentaryFileId)
            if attr.get_user() == anotationDocumentaryFile.user.username:
                logger.info('get_documentary_file_id')
                logger.info(str(attr.get_documentary_file_id()))
                logger.info('anotationDocumentaryFile.documentaryFile.id')
                logger.info(str(anotationDocumentaryFile.documentaryFile.id))
                if str(attr.get_documentary_file_id()) == str(anotationDocumentaryFile.documentaryFile.id):
                    anotationDocumentaryFile.delete()
                    json= '{"annotation_documentary_file_deleted" :'  + str(anotationDocumentaryFileId) + '}'
                    logger.info(json)
                else:
                    json= '{"Error": "DocumentaryFile does not matched"}'
                    logger.info(json) 
                    return json
            else:
                json= '{"Error": "User does not matched"}'
                logger.info(json)
                return json
        except AnnotationDocumentaryFile.DoesNotExist:
            json= '{"error": "AnnotationDocumentaryFile Id not valid"}'
            logger.info(json)
            return json
            
        return json   
