function Streamgraph($selector, data/*, data2*/) 
{
    
    /* Constants */
   
    var VMARGIN = 3,
        YEARSHEIGHT = 20,
        STARTTIME = new Date(data.from_date),
        ENDTIME = new Date(data.to_date),
        DATASTART = new Date(data.from_date),
        DATAEND = new Date(data.to_date),
        CURVE = .25,
        DATEPADDING = 10,
        COLORS = [ "#51585E", "#12161C", "#457DAD", "#899DAA", "#0781BD" ],
		QUERYID = data.query_id,
        SELECTEDCOLOR = "#c51810"; 
    	
    /* Calculating scales and positions */
  
    var width = $selector.width(),
        height = $selector.height(),
        transp = _.zip.apply( _, _(data.clusters).pluck("volumes") ),
        cumulative = _(transp).map(function(column) {
            var total = 0;
            return _(column).map(function(point) {
                return total += point;
            });
        }),
        sums = _(cumulative).map(function(column) {
            return _(column).last();
        })
        maxcol = _(sums).max(),
        streamheight = height - YEARSHEIGHT,
        streamwidth = width * (DATAEND - DATASTART) / (ENDTIME - STARTTIME),
        yscale = (streamheight - 2 * VMARGIN) / maxcol,
        centery = streamheight / 2,
        xscale = streamwidth / (transp.length - 1),
        txscale = width / (ENDTIME - STARTTIME),
        startx = txscale * (DATASTART - STARTTIME),
        endx = txscale * (DATAEND - STARTTIME),
        coords = _(data.clusters).map(function(line, lineindex) {
            return {
                points : _(line.volumes).map(function(point, colindex) {
                    var lowercumul = lineindex ? cumulative[colindex][lineindex - 1] : 0,
                        uppercumul = cumulative[colindex][lineindex];
                    return {
                        data: point,
                        x: startx + xscale * colindex,
                        lowery: centery + yscale * ( ( sums[colindex] / 2 ) - lowercumul ),
                        uppery: centery + yscale * ( ( sums[colindex] / 2 ) - uppercumul ),
                    }
                }),
                id : line.id,
                title: line.title
            }
        }),
        _(coords).each(function(line) {
            var lowerline = _(line.points).reduce(function(path, point, colindex) {
                var res = path;
                if (colindex) {
                    res += "," + (point.x - CURVE * xscale) + "," + point.lowery + "," + point.x + "," + point.lowery;
                } else {
                    res += "M" + point.x + "," + point.lowery;
                }
                if (colindex < line.points.length - 1) {
                    res += "C" + (point.x + CURVE * xscale) + "," + point.lowery;
                }
                return res;
            }, "");
            var upperline = _(line.points).reduceRight(function(path, point, colindex) {
                var res = path;
                if (colindex < line.points.length - 1) {
                    res += "," + (point.x + CURVE * xscale) + "," + point.uppery + "," + point.x + "," + point.uppery;
                } else {
                    res += "L" + point.x + "," + point.uppery;
                }
                if (colindex) {
                    res += "C" + (point.x - CURVE * xscale) + "," + point.uppery;
                }
                return res;
            }, "");
            line.path = lowerline + upperline;
        });
    
    /* Drawing streamgraph*/
   
    $selector.empty();
   
    var paper = new Raphael($selector[0]);
    
    paper.path("M0 " + (1+centery) + "L" + width + " " + (1+centery)).attr({
        stroke: "#000"
    })
    
    _(coords).each(function(line, index) {
        line.color = COLORS[index % COLORS.length];
        //var hue = (parseInt(line.id)%6)/6;
        //line.color = Raphael.hsl( hue, 1, .8 );
        //line.highlightColor = Raphael.hsl( hue, 1, .4 );
        line.surface = paper.path(line.path);
        line.surface.attr({
            stroke: "#ffffff",
            "stroke-width": .25,
            fill: line.color
        });
    });
    
    /* Drawing years */
   
    paper.path("M0," + (height - YEARSHEIGHT) + "," + width + "," + (height - YEARSHEIGHT))
    var lastyear = ENDTIME.getFullYear();
    for (var i = STARTTIME.getFullYear(); i <= lastyear; i++) {
        var x = txscale * (new Date(i,0,1) - STARTTIME);
        paper.path("M" + x + ",0," + x + "," + height);
        var x = txscale * (new Date(i,6,1) - STARTTIME);
        paper.text(x, height - .5 * YEARSHEIGHT, i)
            .attr({
                "text-anchor": "middle",
                "font-family": "Times New Roman, serif",
                "font-size": "14px"
            });
    }
    
    /* Drawing range window */
    
    var carregauche = paper.rect(width,-1,width,(2+height)),
        carredroite = paper.rect(-width,-1,width,(2+height)),
        attrcarres = {
            fill: "#333333",
            "fill-opacity": .5,
            stroke: "#c51810"
        };
    carregauche.attr(attrcarres);
    carredroite.attr(attrcarres);
    
    var rangerect = paper.rect(0, (height - YEARSHEIGHT), width, YEARSHEIGHT);
    rangerect.attr({
        fill: "#c51810",
        stroke: "none"
    });
    
    function datetext(date) {
        var d = new Date(date),
            m = 1+d.getMonth(),
            y = d.getFullYear();
        return ((m < 10 ? "0" : "") + m + "/" + y);
    }
    
    var startdate = paper.text(DATEPADDING, height - .5 * YEARSHEIGHT, datetext(STARTTIME));
    startdate.attr({
        fill: "#ffffff",
        "text-anchor": "start"
    });
    var enddate = paper.text(width - DATEPADDING, height - .5 * YEARSHEIGHT, datetext(ENDTIME));
    enddate.attr({
        fill: "#ffffff",
        "text-anchor": "end"
    });
    
    /* Redrawing time slices for rollover effect */
   var mem = '';
    _(coords).each(function(line, index) {
		line.mousesurface = paper.path(line.path);
		mem += '<li><a href="http://localhost:8000/'+QUERYID+'/'+line.id+'/0/12/0" title="Afficher le cluster" data-cluster-id="' + line.id + '">' + line.title + '</a></li>';
        line.mousesurface.attr({
			stroke: "none",
            fill: line.color,
            opacity: .01,
            title: line.title,
			href: "http://localhost:8000/"+QUERYID+"/"+line.id+"/0/12/0"
        }).mouseover(function() {
			//alert('mousse select');
            $("body").trigger("select-cluster", line.id);
        }).mouseout(function() {
			 //alert('mousse unselect');
            $("body").trigger("unselect-cluster", line.id);

        });
       // $(line.mousesurface.node).attr("data-cluster-id", line.id).parent().attr("data-cluster-id", line.id);
    });

	  $(".cluster").html(mem) ;
     /*  if (typeof (data2) != 'undefined')
		  {
			//  alert('dat2not null');
			  
			  
			  
			  var line = _(coords).find(function(line) 
			  {
           		 return line.id == 1;
        		});
				//alert(line.id);
        	if (line) 
			{
				alert(line.id);
            	line.surface.attr({  fill: SELECTEDCOLOR  });
			}
			
			  
		  }
		  else
		  {
			  alert('dat2 null');
		  }*/
	  $(".actu, .cluster a, .article").hover
	  (
			function() {			
				$("body").trigger("select-cluster", $(this).attr("data-cluster-id"));
			},
			function() {		   
			   $("body").trigger("unselect-cluster", $(this).attr("data-cluster-id"));
			}
       )
		
    $("body").on("unselect-cluster", function(e, clusterid) {
		$(".actu[data-cluster-id='" + clusterid + "'], .cluster a[data-cluster-id='" + clusterid + "'], .article[data-cluster-id='" + clusterid + "']").removeClass("selected");
        var line = _(coords).find(function(line) {
            return line.id == clusterid;
        });
        if (line) {
            line.surface.attr({
                fill: line.color
            });
        }
    });
	
	
		
    $("body").on("select-cluster", function(e, clusterid) {
   	    $(".actu[data-cluster-id='" + clusterid + "'], .cluster a[data-cluster-id='" + clusterid + "'], .article[data-cluster-id='" + clusterid + "']").addClass("selected");
        var line = _(coords).find(function(line) {
            return line.id == clusterid;
        });
        if (line) {
            line.surface.attr({
                fill: SELECTEDCOLOR //line.highlightColor
            });
        }
    });
	
	/*$("body").on("select-cluster", function(e, clusterid)
		 {
            $(".actu[data-cluster-id='" + clusterid + "'], .cluster a[data-cluster-id='" + clusterid + "'], .article[data-cluster-id='" + clusterid + "']").addClass("selected");
        });
        $("body").on("unselect-cluster", function(e, clusterid) {
            $(".actu[data-cluster-id='" + clusterid + "'], .cluster a[data-cluster-id='" + clusterid + "'], .article[data-cluster-id='" + clusterid + "']").removeClass("selected");
        });*/
    
    /* Returning a handler for slide value change */
    
    this.slidevalues = function(left, right) {
        left = left || 0;
        right = right || width;
        carregauche.attr({x: left - width});
        carredroite.attr({x: right});
        startdate.attr({
            x: DATEPADDING + left,
            text: datetext(STARTTIME.valueOf() + left / txscale)
        });
        enddate.attr({
            x: right - DATEPADDING,
            text: datetext(STARTTIME.valueOf() + right / txscale)
        });
        rangerect.attr({
            x: left,
            width: right - left
        });
    }
    
    $("#slider-range").dragslider("values", [startx, endx]);
    this.slidevalues(startx, endx);

}

function loadStreamgraph(data/*,data2*/) {
	
	$(".streamgraph").empty();
    delete window.streamgraph;
	
    //$.getJSON(url, function(data) {
        window.streamgraph = new Streamgraph($(".streamgraph"), data/*,data2*/);
		 streamgraph.slidevalues.apply(streamgraph,$("#slider-range").dragslider("values"));

    //});
}

/*$(function() {
    loadStreamgraph("data/json_streamgraph.json");
})*/
