
from django.db import models
from django.contrib.auth.models import User

'''class User(models.Model):
    name = models.CharField(max_length=200)
    password = models.CharField(max_length=200)
    
    def __unicode__(self):
        return self.name'''
    
class Image(models.Model):
    url = models.CharField(max_length=200)

    def __unicode__(self):
        return self.url
    
class Document(models.Model):
    documentId = models.IntegerField(primary_key=True)
    title = models.CharField(max_length=200)
    description = models.CharField(max_length=400)
    image = models.ForeignKey(Image)
    date= models.DateTimeField()
    def __unicode__(self):
        return str(self.documentId)

class Documentaryfile(models.Model):
    title = models.CharField(max_length=200)
    date = models.DateTimeField()
    description = models.CharField(max_length=400)
    visibility = models.BooleanField(default=False)
    jsontreemap = models.TextField()
    jsonstreamgraph = models.TextField()
    image = models.ForeignKey(Image)
    user = models.ForeignKey(User)
    list_concepts = models.TextField()
    concepts_with_detailed_documents_list = models.TextField()
    
    def __unicode__(self):
        return str(self.id)
           
class Annotationdocument(models.Model):
    description = models.CharField(max_length=200)
    user = models.ForeignKey(User)
    document = models.ForeignKey(Document)
    visibility = models.BooleanField()
    annoted_text = models.CharField(max_length=200,blank=True,null=True)
    annoted_text_page = models.IntegerField(blank=True,null=True)
    annoted_text_offset = models.IntegerField(blank=True,null=True)
    documentaryfile =  models.ForeignKey(Documentaryfile)   
    def __unicode__(self):
        return self.description
    
class AnnotationDocumentaryFile(models.Model):
    description = models.CharField(max_length=200)
    user = models.ForeignKey(User)
    documentaryFile = models.ForeignKey(Documentaryfile)
   
    def __unicode__(self):
        return self.description
    
class Cluster(models.Model):
    title = models.CharField(max_length=200)
    description = models.CharField(max_length=400)
    weight = models.FloatField()
    document = models.ManyToManyField(Document, through="Clusterdocumentweight")
    documentaryfile = models.ForeignKey(Documentaryfile)
    image = models.ForeignKey(Image)

    def __unicode__(self):
        return str(self.id)

class Annotationcluster(models.Model):
    description = models.CharField(max_length=200)
    user = models.ForeignKey(User)
    cluster = models.OneToOneField(Cluster)
       
    def __unicode__(self):
        return self.description
    
class Clusterdocumentweight(models.Model):
    document = models.ForeignKey(Document)
    cluster = models.ForeignKey(Cluster)
    weight = models.FloatField()
    
    # Le couple cluster/document est unique
    class Meta:
        unique_together = ( 'cluster', 'document' )   

class Tag(models.Model):
    value = models.CharField(max_length=50)
    cluster = models.ForeignKey(Cluster,blank=True,null=True)
    annotationcluster = models.ForeignKey(Annotationcluster,blank=True,null=True)
    annotationdocument = models.ForeignKey(Annotationdocument,blank=True,null=True)
    annotationDocumentaryFile = models.ForeignKey(AnnotationDocumentaryFile,blank=True,null=True)
    document = models.ForeignKey(Document,blank=True,null=True)
    def __unicode__(self):
        return self.value
