'''
Created on 8 aout 2012

@author: gerard
'''
import logging
import simplejson

from document.models import AnnotationDocumentaryFile
from document.models import Documentaryfile
from document.models import Image
from django.contrib.auth.models import User
from mediapartdb.MediapartReader import MediapartReader

logger = logging.getLogger('document')

class DocumentaryFiles(object):

    def __init__(self, request):
        self.request = request
      
    def get_files(self,user,offset,count):
        logger.info('get_files user='+str(offset))

        '''attr = DocumentaryFilesGetAttributes(self.request)'''
        
        '''if not attr.get_user():'''
        if not user:
            json = '{"error msg": "user is not defined"}'
            return json
        
        '''if attr.get_offset() == '':'''
        if not offset:
            json = '{"error msg": "no offset defined"}'
            return json
        
        '''if attr.get_count() == '':'''
        if not count:
            json = '{"error msg": "no count defined"}'
            return json
        
        json = {}
        '''json['offset'] = int(attr.get_offset())
        json['count'] = int(attr.get_count())'''
        json['offset'] = int(offset)
        json['count'] = int(count)
        json['user'] = user
        total_count = 0
        nb_articles = 0
        json['documentary_files'] = []
       
        
        the_user = User.objects.filter(username=user)
        reader = MediapartReader()
        if the_user:
            documentaryFiles = Documentaryfile.objects.filter(user_id=the_user[0].id)
            for docfile in documentaryFiles:
                total_count += 1
                if total_count - 1 >= int(offset) and total_count - 1 < int(offset) + int(count):
                    jsonfile = {'id':docfile.id}
                    jsonfile['articles'] = []
                    article_index = 0
                    for thecluster in docfile.cluster_set.all():
                        nb_articles += thecluster.document.count()
                        for thedocument in thecluster.document.all():
                            if article_index < 4:
                                article_index += 1
                                jsonarticle = {'id':str(thedocument.documentId)}
                                jsonarticle['title'] = str(thedocument.title.encode("utf8"))
                                jsonarticle['url_document'] = reader.get_url(str(thedocument.documentId))
                                jsonfile['articles'].append(jsonarticle)
                    jsonfile['nb_articles'] = nb_articles
                    nb_articles = 0
                    jsonfile['date'] = docfile.date.isoformat()
                    jsonfile['description'] = str(docfile.description)
                    jsonfile['title'] = str(docfile.title)
                    image = Image.objects.get(id=docfile.image_id)
                    jsonfile['url_image'] = str(image.url)
                    
                    jsonfile['annotations'] = []
                    annotations = AnnotationDocumentaryFile.objects.filter(documentaryFile_id=docfile.id)
                    for annotation in annotations:
                        jsonannotation = {'id':annotation.id}
                        jsonannotation['user'] = annotation.user_id
                        jsonannotation['text'] = annotation.description
                        jsonfile['annotations'].append(jsonannotation)
                    json['documentary_files'].append(jsonfile)
                json['nb_articles'] = nb_articles
                
                nb_articles = 0    
        json['total_count'] = total_count
        result = simplejson.dumps(json)
        logger.info(result)
        return result  