
var r = new Relations();
var couleurs = d3.scale.category20c();

//*
var parametresStreamgraph = {
	name: "streamgraph",
	selector: "#streamgraph",
	activerSelection : false,
	hauteur: 300,
	largeur: 900,
	relations: r,
	couleurs: couleurs
};


var streamgraph = new Streamgraph(json.clusters, parametresStreamgraph);

var parametresStreamgraphTimeline = {
		name: "streamgraphTimeline",
		selector: "#streamgraphTimeline",
		activerSelection : true,
		activerCurseur: true,
		activerTimeline: true,
		hauteur: 50,
		relations: r,
		couleurs: couleurs
	};

var streamgraphTimeline = new Streamgraph(json.clusters, parametresStreamgraphTimeline);
//*/

//*
var parametresTreemap = {
	name: "treemap",
	selector: "#treemap",
	hauteur: 300,
	largeur: 900,
	relations: r,
	couleurs: couleurs,
	template: {
		selector: "#streamgraphTemplate",
		directives: {
			"img@src": "urlImage",
			"img@title": "titreArticle",
			"img@alt": "titreArticle",
			"img@width": "widthImage",
			"img@height": "heightImage",
			"img@style+": "cssOffsetImage",
			"p.title": "titreArticle"
		}
	}
};
var treemap = new Treemap(json, parametresTreemap);
//*/

//*
r.get("streamgraphTimeline").bind("selectionResize","streamgraph",
		function(objet, params) { objet.resize(params[0], params[1]); })
	.bind("selectionResize", "treemap", 
		function(objet, params) { objet.transition(params[0], params[1]); });

function placerCurseur(cluster) {
	streamgraphTimeline.placerCurseur(parseInt(cluster.attr("datetime")), 'index');
	streamgraphTimeline.showCursor();
}

function cacherCurseur() {
	streamgraphTimeline.hideCursor();
}

for (var i = 0; i<treemap.nbClusters; ++i) {
	var cluster = r.get("treemap.cluster." + i);
	cluster.mouseover(treemap.focus)
		.mouseout(treemap.blur)
		.mouseover(placerCurseur)
		.mouseout(cacherCurseur)
		.mouseover("streamgraph.cluster." + i, streamgraph.focus)
		.mouseout("streamgraph.cluster." + i, streamgraph.blur);
	var stream = r.get("streamgraph.cluster." + i);
	stream.mouseover(streamgraph.focus)
		.mouseout(streamgraph.blur)
		.mouseover("treemap.cluster." + i, treemap.focus)
		.mouseout("treemap.cluster." + i, treemap.blur);
}
//*/