<?php

require_once dirname(__FILE__).'/../lib/filmGeneratorConfiguration.class.php';
require_once dirname(__FILE__).'/../lib/filmGeneratorHelper.class.php';

/**
 * film actions.
 *
 * @package    thd
 * @subpackage film
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12474 2008-10-31 10:41:27Z fabien $
 */
class filmActions extends autoFilmActions
{
	public function executeListReindex(sfWebRequest $request) {

		sfContext::getInstance()->getLogger()->info("FilmAction : listReindex");
		
		//empty solr
		$solr = uvmcSolrServicesManager::getInstance()->getService();
        $solr->deleteByQuery('*:*');
        
        // reset sony engine
        $dispatcher = sfContext::getInstance()->getEventDispatcher();
        $dispatcher->notify(new sfEvent("", 'iri_sonyengine.reset', array('retrain' => true)));
		
		
		$films_array = array();
		$tags_array = array();
		
		// get all films
		$films = Doctrine_Query::create()
		  ->select("f.*")
		  ->from('ThdFilm f')
		  ->execute();
		  
		sfContext::getInstance()->getLogger()->info("Query films : " . print_r($films->count(),true));
		  
		foreach ($films as $film) {
			$films_array[] = $film;
			
			$tags = $film->getTagsArray();
			foreach ($tags as $tag_name) {
				$tags_array[] = array('segment_id'=>$film->uniqueid,'name'=>$tag_name);
			}			
			$dispatcher->notify(new sfEvent($this, 'uvmc_solr.add_document_to_collection', array('object'=>$film, 'commit'=>false)));
		}

		sfContext::getInstance()->getLogger()->info("Query films : films array " . print_r($films->count(),true));
		
		$dispatcher->notify(new sfEvent($this, 'iri_sonyengine.segment_create', array('object'=>$films_array, 'retrain'=>true)));
		$dispatcher->notify(new sfEvent($this, 'iri_sonyengine.tag_add', array('object'=>$tags_array, 'retrain'=>true)));
		
        $dispatcher->notify(new sfEvent($this, 'uvmc_solr.add_collection', array('commit'=>false)));
		$dispatcher->notify(new sfEvent($this, 'uvmc_solr.commit', array()));
		
		$this->redirect("@thd_film_film");
	}
}
