<?php

class myUser extends sfBasicSecurityUser {

  public function login($identity) {
    $this->setAuthenticated(true);

    // Store identity in a cookie
    if (!is_null($identity)) {
      sfContext::getInstance()->getResponse()->setCookie('openid_identity', $identity);
    }
  }

  public function getUid() {
    if (!$this->isAuthenticated()) return false;

    // FIXME
    return "thd.fake";
  }

  public function logout() {
    $this->clearCredentials();
    $this->setAuthenticated(false);
  }

  public function getIdentity() {
    return sfContext::getInstance()->getRequest()->getCookie('openid_identity', null);
  }
}
