<?php

class viewMyTagListAction extends sfAction {

  public function execute($request) {
    // Get pager information
    $pageNb = (int) $this->getRequestParameter('page_nb', 1);
    $this->pageIndex = $pageNb -1;
    $this->pageNbItems = 10;
    $this->routeUri = '@viewMyTagList';

    // Initialize query
    $query = Doctrine_Query::create()
        ->from('ThdFilm F')
        ->leftJoin('F.videos V')
        ->leftJoin('V.segments S')
        ->leftJoin('S.ThdUser U')
        ->where("U.uniqueid = '{$this->getUser()->getUid()}'")
        ->orderBy('S.creation_date DESC');
    $this->itemCount = $query->count();
    $this->pageCount = (int) ceil($this->itemCount/$this->pageNbItems);
    $this->films = $query->offset($this->pageIndex*$this->pageNbItems)->limit($this->pageNbItems)->execute();

    if ($this->pageIndex*$this->pageNbItems > $this->itemCount) {
      $this->forward404();
    }
  }
}