<?php

class viewVideoSegmentListAction extends sfAction
{
  public function execute($request)
  {
	$this->filmSlug = $this->getRequestParameter('film_slug');

	// Get segments
  $query = Doctrine_Query::create()
    ->from('ThdSegment S')
    ->leftJoin('S.ThdVideo V')
    ->leftJoin('V.ThdFilm F')
    ->where("F.slug_url = '{$this->filmSlug}'")
    ->orderBy('S.creation_date DESC');


	//Check if file exist
	$segments = Array();

	foreach ($query->execute() as $segment) {
    $segments[] = Array(
      'in' => $segment->getStart(), 'out' => $segment->getEnd(),
      'tags' => $segment->getTags(), 'user' => $segment->getThdUser()->getUniqueid()
    );
	}

	// Render json
	$this->getResponse()->setHttpHeader('Content-type', 'application/json');
  $this->getResponse()->setHttpHeader('Cache-Control', 'no-cache, no-store, max-age=0');
  return $this->renderText(json_encode($segments));

  }
}