<?php

/**
 * ThdSegment form base class.
 *
 * @package    form
 * @subpackage thd_segment
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 8508 2008-04-17 17:39:15Z fabien $
 */
class BaseThdSegmentForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'            => new sfWidgetFormInputHidden(),
      'start'         => new sfWidgetFormInput(),
      'end'           => new sfWidgetFormInput(),
      'user_id'       => new sfWidgetFormDoctrineChoice(array('model' => 'ThdUser', 'add_empty' => false)),
      'creation_date' => new sfWidgetFormDateTime(),
      'uniqueid'      => new sfWidgetFormInput(),
      'video_id'      => new sfWidgetFormDoctrineChoice(array('model' => 'ThdVideo', 'add_empty' => false)),
    ));

    $this->setValidators(array(
      'id'            => new sfValidatorDoctrineChoice(array('model' => 'ThdSegment', 'column' => 'id', 'required' => false)),
      'start'         => new sfValidatorNumber(),
      'end'           => new sfValidatorNumber(),
      'user_id'       => new sfValidatorDoctrineChoice(array('model' => 'ThdUser')),
      'creation_date' => new sfValidatorDateTime(),
      'uniqueid'      => new sfValidatorString(array('max_length' => 36)),
      'video_id'      => new sfValidatorDoctrineChoice(array('model' => 'ThdVideo')),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'ThdSegment', 'column' => array('uniqueid')))
    );

    $this->widgetSchema->setNameFormat('thd_segment[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ThdSegment';
  }

}
