<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/doctrine/BaseFormFilterDoctrine.class.php');

/**
 * ThdSegment filter form base class.
 *
 * @package    filters
 * @subpackage ThdSegment *
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 11675 2008-09-19 15:21:38Z fabien $
 */
class BaseThdSegmentFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'title'         => new sfWidgetFormFilterInput(),
      'tags'          => new sfWidgetFormFilterInput(),
      'description'   => new sfWidgetFormFilterInput(),
      'video_ref'     => new sfWidgetFormDoctrineChoice(array('model' => 'ThdVideo', 'add_empty' => true)),
      'start'         => new sfWidgetFormFilterInput(),
      'end'           => new sfWidgetFormFilterInput(),
      'user_id'       => new sfWidgetFormFilterInput(),
      'creation_date' => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
      'uniqueid'      => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'title'         => new sfValidatorPass(array('required' => false)),
      'tags'          => new sfValidatorPass(array('required' => false)),
      'description'   => new sfValidatorPass(array('required' => false)),
      'video_ref'     => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdVideo', 'column' => 'id')),
      'start'         => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'end'           => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'user_id'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'creation_date' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'uniqueid'      => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('thd_segment_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ThdSegment';
  }

  public function getFields()
  {
    return array(
      'id'            => 'Number',
      'title'         => 'Text',
      'tags'          => 'Text',
      'description'   => 'Text',
      'video_ref'     => 'ForeignKey',
      'start'         => 'Number',
      'end'           => 'Number',
      'user_id'       => 'Number',
      'creation_date' => 'Date',
      'uniqueid'      => 'Text',
    );
  }
}