<?php

class viewSearchListAction extends sfAction {

  public function execute($request) {
  	// Parse request parameters
    $format = $request->getRequestFormat();
    $this->text = (string) $request->getParameter('text');    
    $this->filter = (string) $request->getParameter('filter', 'all');
    $pageNb = (int) $this->getRequestParameter('page_nb', 1);
    $this->pageIndex = $pageNb -1;
    $this->pageNbItems = 11;
    $this->indexNbItems = 2;
    $this->videoPath = sfConfig::get('app_player_videoPath');
    
    $solr = uvmcSolrServicesManager::getInstance()->getService();
    $response = $solr->search($this->text, $this->pageIndex * $this->pageNbItems, $this->pageNbItems);

    $results = unserialize($response->getRawResponse());              

    $primaryKeys = array();
    foreach($results['response']['docs'] as $doc)
    {
      $primaryKeys[] = $doc['id'];
    }

    if(!empty($primaryKeys))
    {
     
      $this->searchFilms = Doctrine::getTable('ThdFilm')->findByScoredId($primaryKeys);
      $this->selectedFilm = $this->searchFilms->getFirst();     
    }
    else
    {
      $this->searchFilms = array();
    }
    
    return sfView::SUCCESS;
  }
}