<?php

/**
 * reflex actions.
 *
 * @package    thd
 * @subpackage reflex
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z fabien $
 */
class reflexActions extends sfActions
{
 /**
  * Executes index action
  *
  * @param sfRequest $request A request object
  */
  public function executeIndex(sfWebRequest $request)
  {
  	// Parse request parameters
    $format = $request->getRequestFormat();
    $this->film_uniqueid = (string) $request->getParameter('film_uniqueid');   
    $this->tag = (string) $request->getParameter('tag');
    $this->distance = (int)$request->getParameter('distance');
    
    $this->distance = $this->distance / 100.0;

    $client = SonyengineClient::getInstance();
    $results = $client->engineFind($this->film_uniqueid,$this->tag,$this->distance,true);
    foreach($results as $res)
    {
      $primaryKeys[] = $res['id'];
    }
    
    if(!empty($primaryKeys))
    {
      $resultFilm = Doctrine::getTable('ThdFilm')->findByScoredId($primaryKeys);       
    }
    else
    {
      $resultFilm = array();
    }
    
    if(count($resultFilm) > 0) {
    	$this->film = $resultFilm[0];
    }
    else {
    	$this->film = null;
    }
    
    $pageNb = (int) $this->getRequestParameter('page_nb', 1);
    $this->pageIndex = $pageNb -1;
    $this->pageNbItems = 10;
    $this->indexNbItems = 2;

    
    
    $solr = uvmcSolrServicesManager::getInstance()->getService();
    $response = $solr->search("tags:".$this->tag, $this->pageIndex * $this->pageNbItems, $this->pageNbItems);

    $results = unserialize($response->getRawResponse());              

    $primaryKeys = array();
    foreach($results['response']['docs'] as $doc)
    {
      $primaryKeys[] = $doc['id'];
    }

    if(!empty($primaryKeys))
    {
      $this->mostTaggedFilms = Doctrine::getTable('ThdFilm')->findByScoredId($primaryKeys);
    }
    else
    {
      $this->mostTaggedFilms = array();
    }
    
    
    if(count($this->mostTaggedFilms) > 0) {

        $taggedfilms = array();
        foreach($this->mostTaggedFilms as $film) {
        	if($this->film == null || $this->film->id != $film->id) {
                $taggedfilms[] = $film;
            }
        }
        $this->mostTaggedFilms = $taggedfilms;
    }
    
    
    return sfView::SUCCESS;
  }
}
