<?php

/**
 * @package     uvmcSolrSearchPlugin
 * @subpackage  configuration
 * @author      Marc Weistroff <mweistroff@uneviemoinschere.com>
 * @version     $Id: uvmcSolrSearchPluginConfiguration.class.php 21181 2009-08-17 08:18:16Z futurecat $
 */
class iriSonyenginePluginConfiguration extends sfPluginConfiguration
{
  public function initialize()
  {
    if($this->configuration instanceof sfApplicationConfiguration)
    {
      $configCache = $this->configuration->getConfigCache();
      $configCache->registerConfigHandler('config/sonyengine.yml', 'sfDefineEnvironmentConfigHandler', array('prefix' => 'iri_sonyengine_'));
      require_once($configCache->checkConfig('config/sonyengine.yml'));
    }

    $isEnabled = sfConfig::get('iri_sonyengine_enabled', false);
    $isEnabled = $isEnabled == true || $isEnabled == 'on' ? true : false;

    if ($isEnabled)
    {
      $this->connectEvents();
    }
  }

  /**
   * Connect events to listeners
   */
  public function connectEvents()
  {
    $this->dispatcher->connect('iri_sonyengine.find', array('iriSonyengineEventListener', 'listenToFind'));
    $this->dispatcher->connect('iri_sonyengine.train', array('iriSonyengineEventListener', 'listenToEngineTrain'));
    $this->dispatcher->connect('iri_sonyengine.reset', array('iriSonyengineEventListener', 'listenToEngineReset'));
    $this->dispatcher->connect('iri_sonyengine.segment_create', array('iriSonyengineEventListener', 'listenToSegmentCreate'));
    $this->dispatcher->connect('iri_sonyengine.tag_add', array('iriSonyengineEventListener', 'listenToTagAdd'));
  }
}