<?php

/**
 * Display an image according to his source, and cache options
 *
 * request parameters :
 *
 *  -mw max width of the image
 *  -mh max height of the image
 *  -src [ external, relative_to_webdir ]
 *  -fid path identifying the image
 */
class ImageDisplayAction extends sfAction {
	public function execute($request) {
  	// Parse request
  	$fid = $request->getParameter('fid');
    $mw = $request->getParameter('mw');
    $mh = $request->getParameter('mh');
    $imageKey = $fid.'-'.$mw.'x'.$mh;

    // Initialize response headers
    $response = $this->getResponse();
    $manager = UcImageCacheManager::getInstance();
    $etag = $manager->getImageMd5($imageKey);

    // Check etag
    if ($request->getHttpHeader('IF_NONE_MATCH') == $etag) {
        $response->setStatusCode(304);
        $response->setHeaderOnly(true);
        return sfView::NONE;
    }

    // Send resource
    $uri = $request->getUri();
    $ext = substr($uri, strrpos($uri, ".")+1);
    $contentType = 'image/jpeg';
    if ($ext == 'png') $contentType = 'image/png';
    $response->clearHttpHeaders();
    $response->setHttpHeader("Pragma", "public");
    $response->setHttpHeader("ETag", $etag);
    $response->setHttpHeader("Content-Type", $contentType);

    // Set response content
    $response->setContent($manager->getImage($imageKey));
    return sfView::NONE;
	}
}
