<?php

class iriSonyengineEventListener
{
	static function listenToFind(sfEvent $event) {
		
		$segment = $event["segment"];
		$tag = $event["tag"];
		if(isset($event["distantce"])) {
			$distance = $event["distance"];
		}
		else {
			$distance = "0.05";
		}
		if(!isset($event["more"]))
		    $more = "false";
		else
			$more = $event["more"]?"true":"false";
		
		$client = SonyengineClient::getInstance();
		$result = $client->engineFind($segment,$tag,$distance,$more);
		
		$event->setReturnValue($result);
	}
	
	static function listenToEngineTrain(sfEvent $event) {
		$client = SonyengineClient::getInstance();
		$client->engineTrain();
	}
	
	static function listenToEngineReset(sfEvent $event) {
		$client = SonyengineClient::getInstance();
		$client->engineReset();
	}
	
	static function listenToSegmentCreate(sfEvent $event) {
		
		$client = SonyengineClient::getInstance();
		$obj = $event['object'];

		$objs = null;
		
		if(is_array($obj)) {
			$objs = $obj;
		}
		else {
			$objs = array();
			$objs[] = $obj;
		}
		
		$array = array();
		foreach($obj as $obj_instance) {
			$fields = $obj_instance->getSonyengineFields();
			$array[] = $fields["id"];
		}
			
		$client->segmentCreate($array, true);
	}
	
	static function listenToTagAdd(sfEvent $event) {
		
		$client = SonyengineClient::getInstance();
		$obj = $event['object'];

		$objs = null;
		
		if(is_array($obj)) {
			$objs = $obj;
		}
		else {
			$objs = array();
			$objs[] = $obj;
		}
		
		$array = array();
		foreach($obj as $obj_instance) {
			$fields = $obj_instance->getSonyengineFields();
			$array[] = array("segment"=>$fields["segment_id"],"name"=>$fields["name"]);
		}
		
		$client->tagAdd($array, true);
	}
}