<?php
/**
 * Helper used to generate a list of items (object or dictionnary)
 *
 * @param Array $items
 * @param string $nameAccessor
 * @param string $uriAccessor
 * @param string $itemClass
 * @param string $glue
 */
function thd_render_flat_list($items, $nameAccessor, $uriAccessor='', $itemClass='', $glue=', ') {
  $itemsHtml = Array();

  foreach ($items as $key=>$item) {
    $itemName = '';
    $itemUri = '';
    $itemHtml = '';
    $itemClasses = '';

    if (is_array($item)) {
      $itemName = $item[$nameAccessor];
      $itemUri = $uriAccessor ? $item[$uriAccessor]: '';
    } else {
      $itemName = $item->$nameAccessor();
      $itemUri = $uriAccessor ? $item->$uriAccessor() : '';
    }

    if ($itemClass) {
      $itemClasses = ' class="'.$itemClass.'"';
    }

    if ($itemUri) {
      $itemHtml = strtr(
        '<a href="%uri%"%classes%>%name%</a>',
        Array('%name%' => $itemName, '%uri%' => $itemUri, '%classes%' => $itemClasses));
    } else {
      $itemHtml = strtr(
        '<span%classes%>%name%</span>',
        Array('%name%' => $itemName, '%classes%' => $itemClasses));
    }

    $itemsHtml[] = $itemHtml;
  }

  return implode($glue, $itemsHtml);
}

/**
 * Helper used to render a pager navigation
 *
 * @param UcDbPager $pager
 * @param int $pageIndex
 * @param string $routeUri
 */

function thd_render_pager_navigation($pageIndex, $pageCount, $itemCount, $routeUri, $classes='') {
  $words = explode('?', $routeUri);
  $routeUri .= (count($words) == 2) ? '&page_nb=' : '?page_nb=';
  $nbPages = $pageCount;
  if ($nbPages < 2) return '';
  $itemsHtml = Array();
  $pageLimit = 5;
  $pageMiddleLimit = (int) ($pageLimit/2);
  $pageMaxLimit = $pageLimit + $pageMiddleLimit;
  $displayedPages = Array();

  if ($nbPages < ($pageMaxLimit*2)) {
    $displayedPages = Array(range(0, $nbPages-1));
  } else if ($pageIndex >= $pageMaxLimit-1 && $pageIndex <= ($nbPages-$pageMaxLimit)) {
    $displayedPages = Array(range(0, $pageMiddleLimit), range($pageIndex-$pageMiddleLimit, $pageIndex+$pageMiddleLimit), range($nbPages-$pageMiddleLimit-1, $nbPages-1));
  } else if ($pageIndex < $pageMaxLimit) {
    $displayedPages = Array(range(0, ($pageIndex < $pageLimit-$pageMiddleLimit) ? $pageLimit-1 : $pageIndex+$pageMiddleLimit), range($nbPages-$pageMiddleLimit-1, $nbPages-1));
  } else {
    $displayedPages = Array(range(0, $pageMiddleLimit-1), range(($pageIndex > ($nbPages-$pageLimit+1)) ? $nbPages-$pageLimit : $pageIndex-$pageMiddleLimit, $nbPages-1));
  }

  // Add rewind actions
  if ($pageIndex > 0) {
    $itemsHtml[] = '<li class="rewind-first"><a href="'.url_for($routeUri.'1').'">&lt;&lt;</a></li>';
    $itemsHtml[] = '<li class="rewind"><a href="'.url_for($routeUri.''.$pageIndex). '">&lt;</a></li>';
  } else {
    $itemsHtml[] = '<li class="rewind-first disabled"><span>&lt;&lt;</span></li>';
    $itemsHtml[] = '<li class="rewind-first disabled"><span>&lt;</span></li>';
  }

  foreach ($displayedPages as $setIndex=>$pages) {
    foreach ($pages as $index) {
      $pageNb = $index + 1;
      if ($index == $pageIndex) {
        $itemsHtml[] = '<li class="selected"><span>'.$pageNb.'</span></li>';
      } else {
        $pageUri = url_for($routeUri.''.$pageNb);
        $itemsHtml[] = '<li><a href="'.$pageUri. '">'.$pageNb.'</a></li>';
      }
    }

    // add separator
    if ($setIndex < count($displayedPages)-1) {
      $itemsHtml[] = '<li class="separator"><span>...</span></li>';
    }
  }

  // Add forward actions
  if ($pageIndex < ($nbPages-1)) {
    $itemsHtml[] = '<li class="forward"><a href="'.url_for($routeUri.''.($pageIndex+2)).'">&gt;&gt;</a></li>';
    $itemsHtml[] = '<li class="forward-last"><a href="'.url_for($routeUri.''.$nbPages).'">&gt;</a></li>';
  } else {
    $itemsHtml[] = '<li class="forward disabled"><span>&gt;&gt;</span></li>';
    $itemsHtml[] = '<li class="forward-last disabled"><span>&gt;</span></li>';
  }

  $classes = ($classes) ? 'pager-navigation '.$classes : 'pager-navigation';
  return '<div class="'.$classes.'"><ul class="item-list pager-list">'.implode('', $itemsHtml).'</ul></div>';
}

function poster_path($source, $absolute = false) {
   return sfConfig::get('app_poster_root_uri').'/'.$source;
}

function video_path($source, $absolute = false) {
   return sfConfig::get('app_video_root_uri').'/'.$source;
}

function flash_path($source, $absolute = false) {
  return _compute_public_path($source, 'flashes', 'swf', $absolute);
}

function film_video_path($source) {
  return sfConfig::get('app_film_video_root_uri').'/'.$source;
}

function film_image_path($source) {
   return sfConfig::get('app_film_image_root_uri').'/'.$source;
}

/**
 * Helper wich generate submit button
 * [label] = displayed text
 *
 * @param string $label
 */
function uc_render_submit_button($label) {
  return '<button class="submit" type="submit"><span>'.$label.'</span></button>';
}