<?php

class openidLoginAction extends openidAction {

  public function execute($request) {
    // Get openid object
    $openid = $this->getOpenIdObject();

    // Check authentication validity
    $authResult = $openid->getAuthResult();
    $user = $this->getUser();

    if ($authResult['result'] == sfPHPOpenID::AUTH_SUCCESS) {
      // User is authenticated by open id provider
      $user->login($authResult['identity']);
    } else {
      $user->setFlash('login_error', 'Authentification échoué');
    }

    return $this->redirect('@homepage');
  }
}