<?php

class viewTagListAction extends sfAction {

  public function execute($request) {
  	
  	// Parse request parameters
    $format = $request->getRequestFormat();
    $this->tag = (string) $request->getParameter('tag');   
    $pageNb = (int) $this->getRequestParameter('page_nb', 1);
    $this->pageIndex = $pageNb -1;
    $this->pageNbItems = 10;
    $this->indexNbItems = 2;

    
    $solr = uvmcSolrServicesManager::getInstance()->getService();
    $response = $solr->search("tags:".$this->tag, $this->pageIndex * $this->pageNbItems, $this->pageNbItems);

    $results = unserialize($response->getRawResponse());              

    $primaryKeys = array();
    foreach($results['response']['docs'] as $doc)
    {
      $primaryKeys[] = $doc['id'];
    }

    if(!empty($primaryKeys))
    {
      $this->mostTaggedFilms = Doctrine::getTable('ThdFilm')->findByScoredId($primaryKeys);       
    }
    else
    {
      $this->mostTaggedFilms = array();
    }
    
    return sfView::SUCCESS;
  }
}