var uc = uc || {};
uc.utils = uc.utils || {};

uc.utils.centeredContainer = function(html_container) {
	this.html_container = html_container;
}

uc.utils.centeredContainer.currentContainer = null;

uc.utils.centeredContainer.centerCurrent = function() {
	// Center popup in the browser window
	if (uc.utils.centeredContainer.currentContainer == null) return;
	var jq_container = uc.utils.centeredContainer.currentContainer;
	var jq_window = jQuery(window);
	var popup_x = jq_window.scrollLeft() + ((jq_window.width() - jq_container.width()) / 2);
	var popup_y = jq_window.scrollTop() + ((jq_window.height() - jq_container.height()) / 2);
	jq_container.css('top', popup_y);
	jq_container.css('left', popup_x);
}

uc.utils.centeredContainer.showCurrent = function() {
	if (uc.utils.centeredContainer.currentContainer == null) return;
	var jq_container = uc.utils.centeredContainer.currentContainer;
	var jq_window = jQuery(window);
	jq_window.bind("resize", uc.utils.centeredContainer.centerCurrent);
	jq_window.bind("scroll", uc.utils.centeredContainer.centerCurrent);
	uc.utils.centeredContainer.centerCurrent();
	jq_container.show();
}

uc.utils.centeredContainer.hideCurrent = function() {
	if (uc.utils.centeredContainer.currentContainer == null) return;
	var jq_container = uc.utils.centeredContainer.currentContainer;
	var jq_window = jQuery(window);
	jq_container.hide();
	jq_container.remove();
	jq_window.unbind("resize", uc.utils.centeredContainer.centerCurrent);
	jq_window.unbind("scroll", uc.utils.centeredContainer.centerCurrent);
}

uc.utils.centeredContainer.prototype = {
	show: function() {
		this.hide();
		var jq_body = jQuery("body");
		var jq_container = jQuery(this.html_container);
		jq_container.hide();
		jq_container.css('position', 'absolute');
		jq_container.css('display', 'block');
		jq_body.append(jq_container);
		uc.utils.centeredContainer.currentContainer = jq_container;
		uc.utils.centeredContainer.showCurrent();
	},
	hide: function() {
		uc.utils.centeredContainer.hideCurrent();
	}
}

uc.utils.showModalWrapper = function() {
	if (jQuery('#modal-wrapper').length > 0) return false;
	var jq_body = jQuery("body");
	var jq_modal_wrapper = jQuery('<div id="modal-wrapper"></div>');
	jq_modal_wrapper.height(jq_body.height());
	jq_body.append(jq_modal_wrapper);
}

uc.utils.hideModalWrapper = function() {
	jQuery('#modal-wrapper').remove();
}

uc.utils.showLoader = function() {
	var loader = new uc.utils.centeredContainer('<img id="loader" src="/images/pictos/loader.gif" />')
	loader.show();
}

uc.utils.hideLoader = function() {
	jQuery('#loader').remove();
}

uc.utils.executeServerJS = function(http_url, http_data, http_method, complete_callback) {
	if (http_method == null) http_method = 'GET';
	if (complete_callback == null) complete_callback = function () {};

	if (http_method == 'POST') uc.utils.showModalWrapper();
	uc.utils.showLoader();

	jQuery.ajax({
		url: http_url,
		type: http_method,
		data: http_data,
		beforeSend: function(xhr) {xhr.setRequestHeader("Accept", "application/javascript");},
		complete: function (XMLHttpRequest, textStatus) {uc.utils.hideLoader(); complete_callback();},
		success: function (data, textStatus) {},
		dataType: "script"
	});
}

uc.utils.ajaxifyLink = function(jq_selector, http_method, complete_callback) {
	jq_selector.removeClass('ajax').removeClass('ajax-post');
	jq_selector.parents('.ajax').removeClass('ajax').removeClass('ajax-post');

	jq_selector.each(function () {
		var jq_this = jQuery(this);
		var ajax_url = jq_this.attr('href');

		if (ajax_url.indexOf('javascript:') == 0) return false;

		jq_this.attr('href', 'javascript:void(0);');
		jq_this.removeClass('ajax');
		jq_this.click(function() {
			uc.utils.executeServerJS(ajax_url, {}, http_method, complete_callback);
			return false;
		});
	});
}

uc.utils.ajaxifyForm = function(jq_selector, complete_callback) {
	jq_selector.removeClass('ajax');
	jq_selector.submit(function() {
		var jq_this = jQuery(this);
		var ajax_url = jq_this.attr('action');
		var ajax_data = {};

		// Extract data of form
		jQuery('textarea, input:text,  input:password, input:hidden, select, input:checked, input:selected', jq_this).each(function () {
			var jq_input = jQuery(this);
			ajax_data[jq_input.attr('name')] = jq_input.val();
		});

		uc.utils.executeServerJS(ajax_url, ajax_data, 'POST', complete_callback);

		// Do not process normal http request
		return false;
	});
}

uc.utils.buildSelectList = function(jq_selector) {
	// Wait 1 second to make sure css is loaded
	window.setTimeout(function() {
		jq_selector.each(function() {
			var jq_select = jQuery(this);

			// Check for an existing selectedItem
			var jq_selected_item = jQuery('li.selected', jq_select);
			if (jq_selected_item.length == 1) {
				// Scroll to this item
				var top = jq_selected_item.position().top;
				if (top > 200) jq_select.scrollTop(top-200);
			}

			jQuery('li a', jq_select).click(function() {
				jQuery('li.selected', jq_select).toggleClass('selected');
				jQuery(this).parents('li').toggleClass('selected');
			});
		});}, 1000);
}