<?php

/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class ThdFilm extends BaseThdFilm
{
    public function getSonyengineFields()
    {
    	$fields = array('id' => $this->getUniqueid());
    	
    	return $fields;
    }
    
    private function getSolrTextValue($original_value) {
        return $original_value==null?"":strval($original_value);
    }
    
    public function getSolrDocumentFields()
    {
        // keys of this array are fields' name of solr's schema.xml
        $type = "ThdFilm";
        
        $title = $this->getSolrTextValue($this->getTitle());
        $desc = $this->getSolrTextValue($this->getPitch());
        $directors = $this->getSolrTextValue($this->getDirectors());
        $actors = $this->getSolrTextValue($this->getActors());
        $original_title = $this->getSolrTextValue($this->getOriginal_title());
        $tags = $this->getSolrTextValue($this->getTags());
        //$all = implode(" ",array($title,$desc,$directors,$actors,$original_title,$tags));
        
        $fields = array('type'           => $this->getSolrTextValue($type),
                        'id'             => $this->getSolrTextValue($this->getUniqueid()),
                        'title'          => array('value' => $title, 'boost' => 1.0),
                        'desc'           => array('value' => $desc, 'boost' => 1.0),
                        'directors'      => array('value' => $directors, 'boost' => 1.0),
                        'actors'         => array('value' => $actors, 'boost' => 1.0),
                        'original_title' => array('value' => $original_title, 'boost' => 1.0),
                        'uniqueid'       => array('value' => $this->getSolrTextValue($this->getUniqueid()), 'boost' => 1.0),
                        'tags'           => array('value' => $tags, 'boost' => 1.0),
                        //'all'            => array('value' => $all, 'boost' => 1.0),
        );

        sfContext::getInstance()->getLogger()->info("getSolrDocumentFields : " . print_r($fields,true));
        return $fields;
    }

    public function preInsert($event)
    {
        $this->uniqueid = UUID::generate(UUID::UUID_TIME, UUID::FMT_STRING, "mosatags");
    }

    protected function decodeJsonData($attr) {
      $data = $this->getData();
      return json_decode($data[$attr], true);
    }

    public function getDirectorsArray() {
      return $this->decodeJsonData('directors');
    }

    public function getActorsArray() {
      return $this->decodeJsonData('actors');
    }

    public function getProductionCountriesArray() {
      return $this->decodeJsonData('production_countries');
    }
    
    public function getTags() {
    	$tags = "";
    	$q = Doctrine_Query::create()
    	   ->select('s.*')
    	   ->from('ThdSegment s')
    	   ->leftJoin('s.ThdVideo v')
    	   ->leftJoin('v.ThdFilm f')
    	   ->where('f.id = ?', $this->id);
        
    	$segments = $q->fetchArray();
    	
    	foreach($segments as $segment) {
    		$tags .= $segment['tags'].",";
    	}
    	
    	return rtrim($tags,',');
    }
    
    public function getTagsArray() {
    	
    	$tags = $this->getTags();
    	$res = array();
    	
    	foreach (explode(',',$tags) as $tag_name) {
    		$res[] = trim($tag_name);
    	}
    	
    	return $res;
    }
    

}
