<?php

class viewTopFilmListAction extends sfAction {

  public function execute($request) {
    // Get pager information
    $pageNb = (int) $this->getRequestParameter('page_nb', 1);
    $this->pageIndex = $pageNb -1;
    $this->pageNbItems = 10;
    $this->routeUri = '@viewFilmList';

    // Initialize query
     $query = Doctrine_Query::create()
      ->from('ThdFilm F')
      ->leftJoin('F.images I ')
      ->leftJoin('F.videos V')
      //->where("cu.code='{$culture}' AND mo.code='{$module}' AND ms.code='{$section}'")
      ->orderBy('F.ref ASC');
    $this->itemCount = $query->count();
    $this->pageCount = (int) ceil($this->itemCount/$this->pageNbItems);
    $this->films = $query->offset($this->pageIndex*$this->pageNbItems)->limit($this->pageNbItems)->execute();

    if ($this->pageIndex*$this->pageNbItems > $this->itemCount) {
      $this->forward404();
    }
  }
}