<?php


class testActions extends sfActions
{
  /**
   * Executes index action
   *
   * @param sfRequest $request A request object
   */
  public function executeIndex(sfWebRequest $request) {
    if (($handle = fopen("/tmp/thd.csv", "r")) !== FALSE) {
      $index = 0;

      while (($data = fgetcsv($handle, 2000, ";", '"')) !== FALSE) {
        if($index++ == 0) continue;

        // Process simple data
        $code = sprintf('%06d', (int) $data[0]);
        $name = $data[1];
        $title = $data[2];
        $originalTitle = $data[3];
        $pitch = (strlen($data[4]) > 0) ? $data[4] : $data[5];
        $duration = $data[9];
        $productionYear = (int) $data[11];

        // Process directors
        $directors = Array();

        foreach (explode(',', $data[7]) as $datum) {
          $datum = trim($datum);
          if (strlen($datum) == 0) continue;
          $directors[] = Array('name' => $datum);
        }

        // Process actors
        $actors = Array();

        foreach (explode(',', $data[8]) as $datum) {
          $datum = trim($datum);
          if (strlen($datum) == 0) continue;
          $actors[] = Array('name' => $datum);
        }

        // Process production countries
        $productionCountries = Array();

        foreach (explode(',', $data[10]) as $datum) {
          $datum = trim($datum);
          if (strlen($datum) == 0) continue;
          $productionCountries[] = Array('label' => $datum);
        }

        // Create film object
        $film = new ThdFilm();
        $film->setRef($code);
        $film->setSlugUrl($name);
        $film->setTitle($title);
        $film->setOriginalTitle($originalTitle);
        $film->setPitch($pitch);
        $film->setDuration($duration);
        $film->setDirectors(json_encode($directors));
        $film->setActors(json_encode($actors));
        $film->setProductionCountries(json_encode($productionCountries));
        $film->setProductionYear(json_encode($productionYear));
        $film->save();

        // Create video and photo
        $image = new ThdImage();
        $image->setFile($code.'_'.$name.'.jpg');
        $image->setFilmId($film->getId());
        $image->save();
        $video = new ThdVideo();
        $video->setFile($code.'_'.$name.'.f4v');
        $video->setTitle($title);
        $video->setFilmId($film->getId());
        $video->save();
      }

      fclose($handle);
    }
    return sfView::NONE;
  }

  public function executeSegment(sfWebRequest $request) {
    $query = Doctrine_Query::create()
      ->from('ThdSegment')
      ->where("id=1");
    $segment = $query->execute()->getFirst();
    var_dump($segment->getThdTags());
    die();
    return sfView::NONE;
  }
}