<?php
/**
 * Helper used to generate a list of items (object or dictionnary)
 *
 * @param Array $items
 * @param string $nameAccessor
 * @param string $uriAccessor
 * @param string $itemClass
 * @param string $glue
 */
function thd_render_flat_list($items, $nameAccessor, $uriAccessor='', $itemClass='', $glue=', ') {
  $itemsHtml = Array();

  foreach ($items as $key=>$item) {
    $itemName = '';
    $itemUri = '';
    $itemHtml = '';
    $itemClasses = '';

    if (is_array($item)) {
      $itemName = $item[$nameAccessor];
      $itemUri = $uriAccessor ? $item[$uriAccessor]: '';
    } else {
      $itemName = $item->$nameAccessor();
      $itemUri = $uriAccessor ? $item->$uriAccessor() : '';
    }

    if ($itemClass) {
      $itemClasses = ' class="'.$itemClass.'"';
    }

    if ($itemUri) {
      $itemHtml = strtr(
        '<a href="%uri%"%classes%>%name%</a>',
        Array('%name%' => $itemName, '%uri%' => $itemUri, '%classes%' => $itemClasses));
    } else {
      $itemHtml = strtr(
        '<span%classes%>%name%</span>',
        Array('%name%' => $itemName, '%classes%' => $itemClasses));
    }

    $itemsHtml[] = $itemHtml;
  }

  return implode($glue, $itemsHtml);
}

function poster_path($source, $absolute = false) {
   return sfConfig::get('app_poster_root_uri').'/'.$source;
}

function video_path($source, $absolute = false) {
   return sfConfig::get('app_video_root_uri').'/'.$source;
}

function flash_path($source, $absolute = false) {
  return _compute_public_path($source, 'flashes', 'swf', $absolute);
}

function film_video_path($source) {
  return sfConfig::get('app_film_video_root_uri').'/'.$source;
}

function film_image_path($source) {
   return sfConfig::get('app_film_image_root_uri').'/'.$source;
}

/**
 * Helper wich generate submit button
 * [label] = displayed text
 *
 * @param string $label
 */
function uc_render_submit_button($label) {
  return '<button class="submit" type="submit"><span>'.$label.'</span></button>';
}