<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/doctrine/BaseFormFilterDoctrine.class.php');

/**
 * ThdSegmentTag filter form base class.
 *
 * @package    filters
 * @subpackage ThdSegmentTag *
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 11675 2008-09-19 15:21:38Z fabien $
 */
class BaseThdSegmentTagFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'tag_id'     => new sfWidgetFormDoctrineChoice(array('model' => 'ThdTag', 'add_empty' => true)),
      'segment_id' => new sfWidgetFormDoctrineChoice(array('model' => 'ThdSegment', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'tag_id'     => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdTag', 'column' => 'id')),
      'segment_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdSegment', 'column' => 'id')),
    ));

    $this->widgetSchema->setNameFormat('thd_segment_tag_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ThdSegmentTag';
  }

  public function getFields()
  {
    return array(
      'id'         => 'Number',
      'tag_id'     => 'ForeignKey',
      'segment_id' => 'ForeignKey',
    );
  }
}