<?php

class openidLoginAction extends sfAction {

  public function execute($request) {
    // Get openid object
    $identity = $request->getParameter('openid.identity');
    $openid = ThdUtil::getOpenIdObject($identity);

    // Check authentication validity
    $authResult = $openid->getAuthResult();
    $user = $this->getUser();

    if ($authResult['result'] == sfPHPOpenID::AUTH_SUCCESS) {
      // User is authenticated by open id provider
      $serviceUri = sfConfig::get('app_openid_service_uri');
      $login = substr($authResult['identity'], strlen($serviceUri));
      $login = str_replace('/', '', $login);
      $user->login($login);
    } else {
      $user->setFlash('login_error', 'Authentification échoué');
    }

    return $this->redirect('@homepage');
  }
}