<?php

//// cyqui@smile.fr Commentaire useless : Cette classe n'est pas completement utilisé, je l'ai mise car je pense que vous aurez besoin d'effectuer des operations sur les images.
//// et elle etait dans ma bibliotheque personnelle.
class UcImageUtil
{


    /**
     * Resize an image according to his original proportions.
     *
     *
     * @param string $src ( source path of an image in gif / jpeg fromats )
     * @param int $w
     * @param int $h
     * @param string $dst ( file to write, or null )
     * @return mixed
     *
     */
    public static function resample_picfile( $src, $w, $h, $dst = null, $extname=null )
    {

        $extname    = strtolower( substr( strrchr( $src , "."), 1 ) );

        switch( $extname )
        {
            case 'jpeg':
            case 'jpg':

                $create_func = 'imagecreatefromjpeg';
                $out_func    = 'imagejpeg';

            break;
            case 'png':

                $create_func = 'imagecreatefrompng';
                $out_func    = 'imagepng';

            break;
            case 'gif' :

                $create_func = 'imagecreatefromgif';
                $out_func    = 'imagegif';

            break;

            //autodetect
            default:

            $imageinfos = @getimagesize( $src );

            switch( $imageinfos[2] )
            {
            case IMAGETYPE_JPEG:
                $t = 'jpeg';
            break;
            case IMAGETYPE_PNG:
                $t = 'png';
            break;
            case IMAGETYPE_GIF:
                $t = 'gif';
            break;
            }

            $create_func = 'imagecreatefrom'.$t;

            break;
        }

        $src_img = $create_func($src);

        if( $src_img )
        {
            $src_w  = imagesx($src_img);
            $src_h  = imagesy($src_img);

            $scaleX = $w / $src_w;
            $scaleY = $h / $src_h;
            $scale  = min($scaleX, $scaleY);

            $dstW   = $w;
            $dstH   = $h;
            $dstX   = $dstY = 0;

            $scaleR = $scaleX / $scaleY;

            $dstW = (int)($scale * $src_w + 0.5);
            $dstH = (int)($scale * $src_h + 0.5);

            $dstX = 0;
            $dstY = 0;

            $dst_img = ImageCreateTrueColor( $dstW, $dstH );
            imagecopyresampled(
                $dst_img, $src_img, $dstX, $dstY, 0, 0,
                $dstW, $dstH, $src_w, $src_h);


            //write image to file
            if( !is_null( $dst ) )
            {
                if ($t == 'jpeg') {
                  $res = imagejpeg($dst_img, $dst, 100);
                } elseif ($t == 'png') {
                  $res = imagepng($dst_img, $dst, 9);
                } else {
                  $res = imagegif($dst_img, $dst);
                }

                imagedestroy( $dst_img );
            }
            else //display image binary
            {
                if ($t == 'jpeg') {
                  return imagejpeg($dst_img, null, 100);
                } elseif ($t == 'png') {
                  return imagepng($dst_img, null, 9);
                } else {
                  return imagegif($dst_img, null);
                }
            }


            imagedestroy( $src_img );

            if( !is_null( $dst ) )
            {
                 return file_exists( $dst );
            }
        }

        return false;
    }

    /**
     * Resize an image according to his original proportions.
     *
     *
     * @param resource $src ( source path of an image in gif / jpeg fromats )
     * @param int $w
     * @param int $h
     * @param string $dst ( file to write, or null )
     * @return mixed
     *
     */
    public static function resample_pic_resource( $src_img, $w, $h )
    {

        $lowend      = 0.8;
        $highend     = 1.25;

        if( $src_img )
        {
            $src_w  = imagesx($src_img);
            $src_h  = imagesy($src_img);

            $scaleX = (float)$w / $src_w;
            $scaleY = (float)$h / $src_h;
            $scale  = min($scaleX, $scaleY);

            $dstW   = $w;
            $dstH   = $h;
            $dstX   = $dstY = 0;

            $scaleR = $scaleX / $scaleY;

            $dstW = (int)($scale * $src_w + 0.5);
            $dstH = (int)($scale * $src_h + 0.5);

            $dstX = 0;
            $dstY = 0;

            $dst_img = ImageCreateTrueColor( $dstW, $dstH );
            imagecopyresampled(
                $dst_img, $src_img, $dstX, $dstY, 0, 0,
                $dstW, $dstH, $src_w, $src_h);


           return $dst_img;
        }

        return false;
    }

    public static function getMimeTypeForExt( $ext )
    {
        switch( $ext )
        {
            case 'jpg':
            case 'jpeg':

                return 'image/jpeg';

            break;

            case 'gif':

                return 'image/gif';

            break;

        }
    }

    /**
     * Effectue une rotation de 90, 180, 270° sur une image et retourne l'image modifiée
     *
     * @param resource $imgSrc
     * @param int $angle
     * @return resource image
     * @see http://fr2.php.net/imagecopy ( original source code )
     */
    public static function ImageRotateRightAngle( $imgSrc, $angle )
    {

        // ensuring we got really RightAngle (if not we choose the closest one)
        $angle = min( ( (int)(($angle+45) / 90) * 90), 270 );

        // no need to fight
        if( $angle == 0 )
           return( $imgSrc );

        // dimenstion of source image
        $srcX = imagesx( $imgSrc );
        $srcY = imagesy( $imgSrc );

        switch( $angle )
        {
        case 90:
           $imgDest = imagecreatetruecolor( $srcY, $srcX );
           for( $x=0; $x<$srcX; $x++ )
               for( $y=0; $y<$srcY; $y++ )
                   imagecopy($imgDest, $imgSrc, $srcY-$y-1, $x, $x, $y, 1, 1);
           break;

        case 180:
           $imgDest = self::ImageFlip( $imgSrc, self::IMAGE_FLIP_BOTH );
           break;

        case 270:
           $imgDest = imagecreatetruecolor( $srcY, $srcX );
           for( $x=0; $x<$srcX; $x++ )
               for( $y=0; $y<$srcY; $y++ )
                   imagecopy($imgDest, $imgSrc, $y, $srcX-$x-1, $x, $y, 1, 1);
           break;
        }

        return $imgDest;
    }

    /**
     *
     * @param resource $imgSrc
     * @param int $type une valeur parmi IMAGE_FLIP_HORIZONTAL|IMAGE_FLIP_VERTICAL|IMAGE_FLIP_BOTH
     * @return resource image
     * @see http://fr2.php.net/imagecopy ( original source code )
     */
    public static function ImageFlip($imgsrc, $type)
    {
      $width = imagesx($imgsrc);
      $height = imagesy($imgsrc);

      $imgdest = imagecreatetruecolor($width, $height);
       ImageAlphaBlending($imgdest, false);

      switch( $type )
         {
         // mirror wzgl. osi
         case self::IMAGE_FLIP_HORIZONTAL:
             for( $y=0 ; $y<$height ; $y++ )
                 imagecopy($imgdest, $imgsrc, 0, $height-$y-1, 0, $y, $width, 1);
             break;

         case self::IMAGE_FLIP_VERTICAL:
             for( $x=0 ; $x<$width ; $x++ )
                 imagecopy($imgdest, $imgsrc, $width-$x-1, 0, $x, 0, 1, $height);
             break;

         case self::IMAGE_FLIP_BOTH:
             for( $x=0 ; $x<$width ; $x++ )
                 imagecopy($imgdest, $imgsrc, $width-$x-1, 0, $x, 0, 1, $height);

             $rowBuffer = imagecreatetruecolor($width, 1);
             for( $y=0 ; $y<($height/2) ; $y++ )
                 {
                 imagecopy($rowBuffer, $imgdest  , 0, 0, 0, $height-$y-1, $width, 1);
                 imagecopy($imgdest  , $imgdest  , 0, $height-$y-1, 0, $y, $width, 1);
                 imagecopy($imgdest  , $rowBuffer, 0, $y, 0, 0, $width, 1);
                 }

             imagedestroy( $rowBuffer );
             break;
         }

      return $imgdest;
    }
}
