<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/doctrine/BaseFormFilterDoctrine.class.php');

/**
 * ThdSegment filter form base class.
 *
 * @package    filters
 * @subpackage ThdSegment *
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 11675 2008-09-19 15:21:38Z fabien $
 */
class BaseThdSegmentFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'start'         => new sfWidgetFormFilterInput(),
      'end'           => new sfWidgetFormFilterInput(),
      'user_id'       => new sfWidgetFormDoctrineChoice(array('model' => 'ThdUser', 'add_empty' => true)),
      'creation_date' => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
      'uniqueid'      => new sfWidgetFormFilterInput(),
      'video_id'      => new sfWidgetFormDoctrineChoice(array('model' => 'ThdVideo', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'start'         => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'end'           => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'user_id'       => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdUser', 'column' => 'id')),
      'creation_date' => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'uniqueid'      => new sfValidatorPass(array('required' => false)),
      'video_id'      => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdVideo', 'column' => 'id')),
    ));

    $this->widgetSchema->setNameFormat('thd_segment_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ThdSegment';
  }

  public function getFields()
  {
    return array(
      'id'            => 'Number',
      'start'         => 'Number',
      'end'           => 'Number',
      'user_id'       => 'ForeignKey',
      'creation_date' => 'Date',
      'uniqueid'      => 'Text',
      'video_id'      => 'ForeignKey',
    );
  }
}