<?php

/**
 *
 * @author cquintin
 *
 */
class ThdUtil extends sfToolKit
{
    // Normalized chars
    private static $normalizedChars = Array(
      'à' => 'a', 'â' => 'a', 'ä' => 'a',
      'é' => 'e', 'è' => 'e', 'ë' => 'e', 'ê' => 'e',
      'ï' => 'i', 'î' => 'i',
      'ö' => 'o', 'ô' => 'o',
      'ü' => 'u', 'û' => 'u',
      'ç' => 'c');

    static public function normalizeText($text)
    {
      // replace all non letters width normalized characters
      $text = mb_strtolower(trim($text), 'UTF-8');
      $text = strtr($text, self::$normalizedChars);
      $text = preg_replace('/\W+/', '-', $text);
      $text = trim($text, '-');
      return $text;
    }

    static public function cmpTagCloud($a, $b) {
      if ($a['count'] == $b['count']) {
        return 0;
      }

      return ($a['count'] > $b['count']) ? -1 : 1;
    }

    static public function getTagCloud($tagCloud, $nbItems, $maxScore=5) {
      $newTagCloud = $tagCloud;
      uasort($newTagCloud , 'ThdUtil::cmpTagCloud');
      $newTagCloud = array_slice($newTagCloud, 0, $nbItems);

      // Apply maxScore ratio
      if ($newTagCloud) {
        // Get first tag. Assume it has a score of 5
        $firstTagCount = $newTagCloud[0]['count'];
        $scoreRatio = $maxScore/$firstTagCount;

        foreach ($newTagCloud as $index=>$item) {
          $newTagCloud[$index]['count'] = (int) ceil($item['count']*$scoreRatio);
        }
      }

      return $newTagCloud;
    }
}
