<?php

/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class ThdVideo extends BaseThdVideo
{
  public function addSegment($start, $end, $tags, $userUid) {
    $userObj = ThdUser::addUser($userUid);
    $segmentObj = new ThdSegment();
    $segmentObj->setStart($start);
    $segmentObj->setEnd($end);
    $segmentObj->setUserId($userObj->getId());
    $segmentObj->setVideoId($this->getId());
    $segmentObj->save();

    // Add tags to segment
    foreach ($tags as $tag) {
      $tagObj = ThdTag::addTag($tag);
      $segmentTagObj = new ThdSegmentTag();
      $segmentTagObj->setSegmentId($segmentObj->getId());
      $segmentTagObj->setTagId($tagObj->getId());
      $segmentTagObj->save();
    }

    return $segmentObj;
  }

  public function getThdSegments() {
    $query = Doctrine_Query::create()
      ->from('ThdSegment')
      ->where("video_id='{$this->getId()}'");
    return $query->execute()->getData();
  }

  public function getTags() {
    $tags = Array();

    foreach ($this->getThdSegments() as $item) {
      $tags = array_merge($tags, $item->getTags());
    }

    return $tags;
  }

  public function getDistinctTags() {
    $tags = Array();

    foreach ($this->getThdSegments() as $item) {
      foreach ($item->getDistinctTags() as $tag) {
        if (in_array($tag, $tags)) continue;
        $tags[] = $tag;
      }
    }

    return $tags;
  }
}