CREATE TABLE thd_film (id INT, ref INT NOT NULL, title VARCHAR(255) NOT NULL, pitch TEXT NOT NULL, duration INT NOT NULL, directors TEXT NOT NULL, actors TEXT NOT NULL, slug_url VARCHAR(255) NOT NULL, original_title VARCHAR(255), production_year BIGINT, uniqueid VARCHAR(36) NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_image (id INT AUTO_INCREMENT, film_ref INT NOT NULL, type TINYINT NOT NULL, file VARCHAR(255) NOT NULL, INDEX film_ref_idx (film_ref), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_segment (id INT AUTO_INCREMENT, title VARCHAR(255) NOT NULL, video_ref INT NOT NULL, start DOUBLE NOT NULL, end DOUBLE NOT NULL, user_id INT NOT NULL, creation_date DATETIME NOT NULL, uniqueid VARCHAR(36) NOT NULL, INDEX video_ref_idx (video_ref), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_video (id INT AUTO_INCREMENT, ref INT NOT NULL, film_ref INT NOT NULL, file VARCHAR(255) NOT NULL, title VARCHAR(255), INDEX ref_idx (ref), INDEX film_ref_idx (film_ref), PRIMARY KEY(id)) ENGINE = INNODB;
ALTER TABLE thd_image ADD FOREIGN KEY (film_ref) REFERENCES thd_film(ref);
ALTER TABLE thd_segment ADD FOREIGN KEY (video_ref) REFERENCES thd_video(ref);
ALTER TABLE thd_video ADD FOREIGN KEY (film_ref) REFERENCES thd_film(ref);
