/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.Arg;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;

public class JMXAccessorCreateTask
extends JMXAccessorTask {
    private String className;
    private String classLoader;
    private List args = new ArrayList();
    private static final String info = "org.apache.catalina.ant.JMXAccessorCreateTask/1.0";

    public String getInfo() {
        return info;
    }

    public String getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(String classLoaderName) {
        this.classLoader = classLoaderName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addArg(Arg arg) {
        this.args.add(arg);
    }

    public List getArgs() {
        return this.args;
    }

    public void setArgs(List args) {
        this.args = args;
    }

    public String jmxExecute(MBeanServerConnection jmxServerConnection) throws Exception {
        if (this.getName() == null) {
            throw new BuildException("Must specify a 'name'");
        }
        if (this.className == null) {
            throw new BuildException("Must specify a 'className' for get");
        }
        return this.jmxCreate(jmxServerConnection, this.getName());
    }

    protected String jmxCreate(MBeanServerConnection jmxServerConnection, String name) throws Exception {
        String error = null;
        Object[] argsA = null;
        String[] sigA = null;
        if (this.args != null) {
            argsA = new Object[this.args.size()];
            sigA = new String[this.args.size()];
            for (int i = 0; i < this.args.size(); ++i) {
                Arg arg = (Arg)this.args.get(i);
                if (arg.type == null) {
                    arg.type = "java.lang.String";
                    sigA[i] = arg.getType();
                    argsA[i] = arg.getValue();
                    continue;
                }
                sigA[i] = arg.getType();
                argsA[i] = this.convertStringToType(arg.getValue(), arg.getType());
            }
        }
        if (this.classLoader != null && !"".equals(this.classLoader)) {
            if (this.isEcho()) {
                this.handleOutput("create MBean " + name + " from class " + this.className + " with classLoader " + this.classLoader);
            }
            if (this.args == null) {
                jmxServerConnection.createMBean(this.className, new ObjectName(name), new ObjectName(this.classLoader));
            } else {
                jmxServerConnection.createMBean(this.className, new ObjectName(name), new ObjectName(this.classLoader), argsA, sigA);
            }
        } else {
            if (this.isEcho()) {
                this.handleOutput("create MBean " + name + " from class " + this.className);
            }
            if (this.args == null) {
                jmxServerConnection.createMBean(this.className, new ObjectName(name));
            } else {
                jmxServerConnection.createMBean(this.className, new ObjectName(name), argsA, sigA);
            }
        }
        return error;
    }
}

