<?php

/**
 * The route UcImageCachedUrl is used to compose the URL.
 *
 # Sample declaration :
 UcImageCachedUrl:
 url: /dynimage/:mw/:mh/:fid/*
 param: { module: ucimagescaler, action: ImageDisplay }

 */
function uc_url_for_scimage( $urlImage, $mw, $mh, $useTransparency=false, $filename='', $keepRatio=true)
{
  if( $filename == '' )
  {
    $filename = strrchr( $urlImage, "/" );
    $filename = substr($filename, 1);

    // Create jpeg
    if (!$useTransparency) {
      $filename = substr($filename, 0, strrpos($filename, '.')).'.jpg';
    }
  }

  $imgid    = UcImageCacheManager::getInstance() -> getOrCreatedCachedImageId($urlImage, $mw, $mh , $useTransparency, $keepRatio);
  $imageUrl =  sfConfig::get('app_image_cache_host').url_for("@UcImageScalerCachedImageUrl?mw=$mw&mh=$mh&fid=$imgid&fname=$filename");
  return $imageUrl;
}
/**
 *
 * return an image tag
 * Sample :

 <div style="background-color:red;">
 <?php
 echo uc_imgtag_scimage('http://www.fond-ecran-image.com/galerie-membre,mante-religieuse,manthe-jpeg.jpg', "100", "50", "mantereligieuse.jpg" );
 echo uc_imgtag_scimage('http://www.fond-ecran-image.com/galerie-membre,mante-religieuse,manthe-jpeg.jpg', "200", "100", "mantereligieuse.jpg" );
 echo uc_imgtag_scimage('http://www.fond-ecran-image.com/galerie-membre,mante-religieuse,manthe-jpeg.jpg', "500", "500", "mantereligieuse.jpg" );
 echo uc_imgtag_scimage('http://www.fond-ecran-image.com/ginexistant.jpg', "500", "500", "mantereligieuse.jpg" );
 ?>
 </div>

 * @param string $urlImage
 * @param int $mw
 * @param int $mh
 * @param string $filename
 * @param array $htmlattributes
 * @return string
 */
function uc_imgtag_scimage( $urlImage, $mw, $mh, $useTransparency=false, $filename = '', $htmlattributes = Array() )
{
  $url   = uc_url_for_scimage( $urlImage, $mw, $mh, $useTransparency, $filename );
  $attrs = '';

  foreach( $htmlattributes as $name=>$value )
  {
    $attrs = ' '.$name.'="'.$value.'"';
  }
  return '<img src="'.$url.'"'.$attrs.' />';
}