<?php

class homepageComponents extends sfComponents
{
  public function executeSideBar() {

  }
  public function executeTagList() {
    // FIXME: Dummy value
    $this->tagList = Array();
    $this->tag = Array('score' => 3);
    // Get Tags in Segment list
    $query = Doctrine_Query::create()
        ->from('ThdSegment S')
        ->limit(5);
    $this->tagsList = $query->execute();

  }

  public function executeRandomFilm() {

    // Initialize query
  	$query = Doctrine_Query::create()
        ->from('ThdFilm F')
        ->leftJoin('F.images I ')
        ->leftJoin('F.videos V')
        //->where("cu.code='{$culture}' AND mo.code='{$module}' AND ms.code='{$section}'")
        ->orderBy('RAND()');
    $this->film = $query->execute()->getFirst();

   // Get image filename
    $images = $this->film->getImages();
    $this->imageFilename = null;

    if ($images) {
      $image = $images[0];
      $this->imageFilename = $image->getFile();
    }


    // Get Tag cloud
    // Only display 10 tags
    $this->tagCloud = ThdUtil::getTagCloud($this->film->getTagCloud(), 10);

    // Get video filename
    $videos = $this->film->getVideos();
    $this->videoFilename = null;

    if ($videos) {
      $video = $videos[0];
      $this->videoFilename = $video->getFile();
    }

    // Create tag action
    $controller = $this->getController();
    $this->actionUri = $controller->genUrl('@editVideoSegment?film_slug='.$this->film->getSlugUrl());
  
  }

  public function executeLastTaggedList() {
    // FIXME: Dummy value
    $this->tag = Array('score' => 3);
  	$query = Doctrine_Query::create()
        ->from('ThdFilm F')
        ->leftJoin('F.images I ')
        ->leftJoin('F.videos V')
        //->where("cu.code='{$culture}' AND mo.code='{$module}' AND ms.code='{$section}'")
        ->orderBy('F.id DESC')
        ->limit(5);
    $this->lastTaggedFilms = $query->execute();
    $this->videoPath = sfConfig::get('app_player_videoPath');

  }
  public function executeMostTaggedList() {
    // FIXME: Dummy value
    $this->tag = Array('score' => 3);
	  $query = Doctrine_Query::create()
      ->from('ThdFilm F')
      ->leftJoin('F.images I ')
      ->leftJoin('F.videos V')
      //->where("cu.code='{$culture}' AND mo.code='{$module}' AND ms.code='{$section}'")
      ->orderBy('F.ref ASC')
      ->limit(5);
    $this->mostTaggedFilms = $query->execute();
    $this->videoPath = sfConfig::get('app_player_videoPath');
  }

  public function executeResultList(sfWebRequest $request) {

  	$text = $request->getParameter('text');

  	$event = $this->dispatcher->notify(new sfEvent($this, 'uvmc_solr.search', array('query' => $text)));
    $response = $event->getReturnValue();
    // solr is configured to give you back a serialized php array
    $rawResp = $response->getRawResponse();
    $results = unserialize($rawResp);



    $primaryKeys = array();
    foreach($results['response']['docs'] as $doc)
    {
    	if($doc['uniqueid'])
    	{
            $primaryKeys[] = $doc['uniqueid'];
    	}
    }

    if(!empty($primaryKeys))
    {
      $this->searchResult = Doctrine::getTable('ThdFilm')->findByScoredId($primaryKeys);
      $this->searchCount = $this->searchResult->count();
    }
    else
    {
      $this->searchResult = array();
      $this->searchCount = 0;
    }


    /*$query = Doctrine_Query::create()
      ->from('ThdFilm F')
      ->leftJoin('F.images I ')
      ->leftJoin('F.videos V')
      ->orderBy('F.id DESC')
      ->limit(0,10);
    $this->searchResult = $query->execute();*/
  }
}