CREATE TABLE thd_film (id INT UNSIGNED AUTO_INCREMENT, ref VARCHAR(255) NOT NULL, title VARCHAR(255) NOT NULL, pitch TEXT NOT NULL, duration INT NOT NULL, directors TEXT NOT NULL, actors TEXT NOT NULL, slug_url VARCHAR(255) NOT NULL, original_title VARCHAR(255), production_countries TEXT NOT NULL, production_year BIGINT, uniqueid VARCHAR(36) NOT NULL, UNIQUE INDEX uniqueidindex_idx (uniqueid), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_user (id INT UNSIGNED AUTO_INCREMENT, uniqueid VARCHAR(255) NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_segment_tag (id INT UNSIGNED AUTO_INCREMENT, tag_id INT UNSIGNED NOT NULL, segment_id INT UNSIGNED NOT NULL, INDEX segment_id_idx (segment_id), INDEX tag_id_idx (tag_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_image (id INT UNSIGNED AUTO_INCREMENT, file VARCHAR(255) NOT NULL, film_id INT UNSIGNED NOT NULL, INDEX film_id_idx (film_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_video (id INT UNSIGNED AUTO_INCREMENT, file VARCHAR(255) NOT NULL, title VARCHAR(255), film_id INT UNSIGNED NOT NULL, INDEX film_id_idx (film_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_tag (id INT UNSIGNED AUTO_INCREMENT, tag VARCHAR(255), uniqueid VARCHAR(255) NOT NULL, UNIQUE INDEX uniqueidindex_idx (uniqueid), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_segment (id INT UNSIGNED AUTO_INCREMENT, start DOUBLE NOT NULL, end DOUBLE NOT NULL, user_id INT UNSIGNED NOT NULL, creation_date DATETIME NOT NULL, uniqueid VARCHAR(36) NOT NULL, video_id INT UNSIGNED NOT NULL, UNIQUE INDEX uniqueidindex_idx (uniqueid), INDEX video_id_idx (video_id), INDEX user_id_idx (user_id), PRIMARY KEY(id)) ENGINE = INNODB;
ALTER TABLE thd_segment_tag ADD FOREIGN KEY (tag_id) REFERENCES thd_tag(id) ON DELETE CASCADE;
ALTER TABLE thd_segment_tag ADD FOREIGN KEY (segment_id) REFERENCES thd_segment(id) ON DELETE CASCADE;
ALTER TABLE thd_image ADD FOREIGN KEY (film_id) REFERENCES thd_film(id) ON DELETE CASCADE;
ALTER TABLE thd_video ADD FOREIGN KEY (film_id) REFERENCES thd_film(id) ON DELETE CASCADE;
ALTER TABLE thd_segment ADD FOREIGN KEY (video_id) REFERENCES thd_video(id) ON DELETE CASCADE;
ALTER TABLE thd_segment ADD FOREIGN KEY (user_id) REFERENCES thd_user(id) ON DELETE CASCADE;
