<?php

class ThdDoctrineListener extends Doctrine_Record_Listener {

  public function postInsert(Doctrine_Event $event) {
    $obj = $event->getInvoker();

    if (method_exists($obj, 'getSolrDocumentFields'))
    {
        $dispatcher = sfContext::getInstance()->getEventDispatcher();
		$dispatcher->notify(new sfEvent($mySubject, 'uvmc_solr.add_document', array('object' => $obj, 'commit' => true)));
    }
    
    // Index in solr
    sfContext::getInstance()->getLogger()->info("Insert object. Index in solr");
  }

  public function postUpdate(Doctrine_Event $event) {
    $obj = $event->getInvoker();

    if (method_exists($obj, 'getSolrDocumentFields'))
    {
        $dispatcher = sfContext::getInstance()->getEventDispatcher();
		$dispatcher->notify(new sfEvent($mySubject, 'uvmc_solr.update_document', array('object' => $obj, 'commit' => true)));
    }
    
    // Reindex in solr
    sfContext::getInstance()->getLogger()->info("Update object. Reindex in solr");
  }
  
  public function preDelete(Doctrine_Event $event) {
  		$obj = $event->getInvoker();
  		if (method_exists($obj, 'getSolrDocumentFields'))
    	{
        	$dispatcher = sfContext::getInstance()->getEventDispatcher();
			$dispatcher->notify(new sfEvent($mySubject, 'uvmc_solr.delete_document', array('object' => $obj, 'commit' => true)));
   	 	} 		
  }
}