<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/doctrine/BaseFormFilterDoctrine.class.php');

/**
 * ThdVideo filter form base class.
 *
 * @package    filters
 * @subpackage ThdVideo *
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 11675 2008-09-19 15:21:38Z fabien $
 */
class BaseThdVideoFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'ref'     => new sfWidgetFormFilterInput(),
      'file'    => new sfWidgetFormFilterInput(),
      'title'   => new sfWidgetFormFilterInput(),
      'film_id' => new sfWidgetFormDoctrineChoice(array('model' => 'ThdFilm', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'ref'     => new sfValidatorPass(array('required' => false)),
      'file'    => new sfValidatorPass(array('required' => false)),
      'title'   => new sfValidatorPass(array('required' => false)),
      'film_id' => new sfValidatorDoctrineChoice(array('required' => false, 'model' => 'ThdFilm', 'column' => 'id')),
    ));

    $this->widgetSchema->setNameFormat('thd_video_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ThdVideo';
  }

  public function getFields()
  {
    return array(
      'id'      => 'Number',
      'ref'     => 'Text',
      'file'    => 'Text',
      'title'   => 'Text',
      'film_id' => 'ForeignKey',
    );
  }
}