CREATE TABLE thd_film (id INT UNSIGNED AUTO_INCREMENT, ref VARCHAR(255) NOT NULL, title VARCHAR(255) NOT NULL, pitch TEXT NOT NULL, duration INT NOT NULL, directors TEXT NOT NULL, actors TEXT NOT NULL, slug_url VARCHAR(255) NOT NULL, original_title VARCHAR(255), production_countries TEXT NOT NULL, production_year BIGINT, uniqueid VARCHAR(36) NOT NULL, UNIQUE INDEX uniqueidindex_idx (uniqueid), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_image (id INT UNSIGNED AUTO_INCREMENT, file VARCHAR(255) NOT NULL, film_id INT UNSIGNED NOT NULL, INDEX film_id_idx (film_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_video (id INT UNSIGNED AUTO_INCREMENT, file VARCHAR(255) NOT NULL, title VARCHAR(255), film_id INT UNSIGNED NOT NULL, INDEX film_id_idx (film_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE thd_segment (id INT UNSIGNED AUTO_INCREMENT, title VARCHAR(255), tags TEXT, description TEXT, video_ref INT NOT NULL, start DOUBLE NOT NULL, end DOUBLE NOT NULL, user_id INT NOT NULL, creation_date DATETIME NOT NULL, uniqueid VARCHAR(36) NOT NULL, video_id INT UNSIGNED NOT NULL, UNIQUE INDEX uniqueidindex_idx (uniqueid), INDEX video_id_idx (video_id), PRIMARY KEY(id)) ENGINE = INNODB;
ALTER TABLE thd_image ADD FOREIGN KEY (film_id) REFERENCES thd_film(id) ON DELETE CASCADE;
ALTER TABLE thd_video ADD FOREIGN KEY (film_id) REFERENCES thd_film(id) ON DELETE CASCADE;
ALTER TABLE thd_segment ADD FOREIGN KEY (video_id) REFERENCES thd_video(id) ON DELETE CASCADE;
