package csl.tools.weka;

import java.util.Formatter;

public class BooleanConfusionMatrix {

	Double	tp, fn, fp, tn;

	public BooleanConfusionMatrix(Double tp, Double fn, Double fp, Double tn) {

		super();
		this.tp = tp;
		this.fn = fn;
		this.fp = fp;
		this.tn = tn;
	}

	public int diff(BooleanConfusionMatrix m) {

		if (m == null)
			return 0;
		int diff = 0;
		if (tp > m.tp)
			diff++;
		if (tn > m.tn)
			diff++;
		if (fp < m.fp)
			diff++;
		if (fn < m.fn)
			diff++;
		if (tp < m.tp)
			diff--;
		if (tn < m.tn)
			diff--;
		if (fp > m.fp)
			diff--;
		if (fn > m.fn)
			diff--;
		return diff;
	}

	public int rawDiff(BooleanConfusionMatrix m) {

		if (m == null)
			return 0;
		int diff = 0;
		diff += tp - m.tp;
		diff += tn - m.tn;
		diff -= fp - m.fp;
		diff -= fn - m.fn;
		return diff;
	}

	public int trueDiff(BooleanConfusionMatrix m) {

		if (m == null)
			return 0;
		int diff = 0;
		diff += tp - m.tp;
		diff += tn - m.tn;
		return diff;
	}

	public int falseDiff(BooleanConfusionMatrix m) {

		if (m == null)
			return 0;
		int diff = 0;
		diff += fp - m.fp;
		diff += fn - m.fn;
		return diff;
	}

	public int trueHDiff(BooleanConfusionMatrix m) {

		if (m == null)
			return 0;
		int diff = 0;
		diff += tp - m.tp;
		diff -= fn - m.fn;
		return diff;
	}

	public int falseHDiff(BooleanConfusionMatrix m) {

		if (m == null)
			return 0;
		int diff = 0;
		diff += tn - m.tn;
		diff -= fp - m.fp;
		return diff;
	}

	public BooleanConfusionMatrix matDiff(BooleanConfusionMatrix m) {

		BooleanConfusionMatrix diff = new BooleanConfusionMatrix(tp - m.tp, fn - m.fn, fp
				- m.fp, tn - m.tn);
		return diff;
	}

	@Override
	public String toString() {

		Formatter formatter = new Formatter();
		formatter
				.format(
						"True\tFalse\t<-- as\n%+5.0f\t%+5.0f\tTrue\n%+5.0f\t%+5.0f\tFalse",
						tp, fn, fp, tn);
		return formatter.toString();
	}
}
