/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibrary;
import weka.core.Utils;
import weka.gui.ensembleLibraryEditor.LibrarySerialization;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;
import weka.gui.ensembleLibraryEditor.ModelList;

public class DefaultModelsPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -6123488873592563339L;
    public static final String PROPERTY_FILE = "DefaultModels.props";
    protected static Properties DEFAULT_PROPERTIES;
    public String[] EXCLUDE_OPTIONS = new String[]{"Train Time", "Test Time", "File Size"};
    private String[] m_DefaultFileNames;
    private String[] m_LargeFileSizeModels;
    private String[] m_LargeTrainTimeModels;
    private String[] m_LargeTestTimeModels;
    private JComboBox m_ExcludeModelsComboBox;
    private JButton m_ExcludeModelsButton;
    private JComboBox m_DefaultFilesComboBox;
    private JButton m_RefreshButton;
    private ModelList m_ModelList;
    private JButton m_RemoveSelectedButton;
    private JButton m_AddAllButton;
    private JButton m_AddSelectedButton;
    private ListModelsPanel m_ListModelsPanel;
    private boolean m_ListUpdatePending = false;

    public DefaultModelsPanel(ListModelsPanel listModelsPanel) {
        this.m_ListModelsPanel = listModelsPanel;
        this.readProperties();
        this.createDefaultModelsPanel();
    }

    private void readProperties() {
        this.m_DefaultFileNames = DEFAULT_PROPERTIES.getProperty("files").split(", ");
        this.m_LargeTrainTimeModels = DEFAULT_PROPERTIES.getProperty("train_time").split(", ");
        this.m_LargeTestTimeModels = DEFAULT_PROPERTIES.getProperty("test_time").split(", ");
        this.m_LargeFileSizeModels = DEFAULT_PROPERTIES.getProperty("file_size").split(", ");
    }

    private void createDefaultModelsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Select default set: ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel, gridBagConstraints);
        this.m_DefaultFilesComboBox = new JComboBox<String>(this.m_DefaultFileNames);
        this.m_DefaultFilesComboBox.setSelectedItem(this.m_DefaultFileNames[0]);
        this.m_DefaultFilesComboBox.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.m_DefaultFilesComboBox, gridBagConstraints);
        this.m_RefreshButton = new JButton("Reload set");
        this.m_RefreshButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.m_RefreshButton, gridBagConstraints);
        JLabel jLabel2 = new JLabel("Exclude models w/ large");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel2, gridBagConstraints);
        this.m_ExcludeModelsComboBox = new JComboBox<String>(this.EXCLUDE_OPTIONS);
        this.m_ExcludeModelsComboBox.setSelectedItem(this.EXCLUDE_OPTIONS[0]);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.m_ExcludeModelsComboBox, gridBagConstraints);
        this.m_ExcludeModelsButton = new JButton("Exclude");
        this.m_ExcludeModelsButton.setToolTipText("Exclude this type of models from the current working list");
        this.m_ExcludeModelsButton.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.m_ExcludeModelsButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Working set of Default Library Models"));
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = 4601977182190493654L;

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = DefaultModelsPanel.this.m_ModelList.getSelectedValues();
                ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)DefaultModelsPanel.this.m_ModelList.getModel();
                for (int i = 0; i < objectArray.length; ++i) {
                    sortedListModel.removeElement((EnsembleLibraryModel)objectArray[i]);
                }
                int[] nArray = new int[]{DefaultModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                DefaultModelsPanel.this.m_ModelList.setSelectedIndices(nArray);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setLayoutOrientation(0);
        ToolTipManager.sharedInstance().registerComponent(this.m_ModelList);
        JScrollPane jScrollPane = new JScrollPane(this.m_ModelList);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(150, 50));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)jPanel, gridBagConstraints);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.addActionListener(this);
        this.m_RemoveSelectedButton.setToolTipText("Remove the selected models from the current default set");
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gridBagConstraints);
        this.m_AddSelectedButton = new JButton("Add Selected");
        this.m_AddSelectedButton.addActionListener(this);
        this.m_AddSelectedButton.setToolTipText("Add selected models in above list to the library");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.m_AddSelectedButton, gridBagConstraints);
        this.m_AddAllButton = new JButton("Add All");
        this.m_AddAllButton.addActionListener(this);
        this.m_AddAllButton.setToolTipText("Add all models in the abovelist to the Libray");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.m_AddAllButton, gridBagConstraints);
        this.m_ListUpdatePending = true;
    }

    public void updateDefaultList() {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).clear();
        String string = DefaultModelsPanel.getPackageName();
        int n = this.m_DefaultFilesComboBox.getSelectedIndex();
        Vector vector = null;
        try {
            Object object;
            LibrarySerialization librarySerialization = new LibrarySerialization();
            String string2 = string + this.m_DefaultFileNames[n].trim() + ".model.xml";
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
            if (inputStream == null) {
                object = new File(string2);
                if (((File)object).exists()) {
                    System.out.println("file existed: " + ((File)object).getPath());
                } else {
                    System.out.println("file didn't exist: " + ((File)object).getPath());
                }
            }
            vector = (Vector)librarySerialization.read(ClassLoader.getSystemResourceAsStream(string2));
            object = vector.iterator();
            while (object.hasNext()) {
                EnsembleLibraryModel ensembleLibraryModel = this.m_ListModelsPanel.getLibrary().createModel((Classifier)object.next());
                ensembleLibraryModel.testOptions();
                ((ModelList.SortedListModel)this.m_ModelList.getModel()).add(ensembleLibraryModel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        if (actionEvent.getSource() == this.m_RefreshButton) {
            this.updateDefaultList();
        } else if (actionEvent.getSource() == this.m_DefaultFilesComboBox) {
            this.updateDefaultList();
        } else if (actionEvent.getSource() == this.m_RemoveSelectedButton) {
            Object[] objectArray = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                sortedListModel.removeElement(objectArray[i]);
            }
            if (this.m_ModelList.getSelectedIndices().length > 0) {
                int[] nArray = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(nArray);
            }
        } else if (actionEvent.getSource() == this.m_AddAllButton) {
            Iterator iterator = sortedListModel.iterator();
            while (iterator.hasNext()) {
                EnsembleLibraryModel ensembleLibraryModel = (EnsembleLibraryModel)iterator.next();
                this.m_ListModelsPanel.addModel(ensembleLibraryModel);
            }
            sortedListModel.clear();
        } else if (actionEvent.getSource() == this.m_AddSelectedButton) {
            Object[] objectArray = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_ListModelsPanel.addModel((EnsembleLibraryModel)objectArray[i]);
                sortedListModel.removeElement(objectArray[i]);
            }
        } else if (actionEvent.getSource() == this.m_ExcludeModelsButton) {
            if (this.m_ExcludeModelsComboBox.getSelectedIndex() == 0) {
                this.applyTrainTimeFilters();
            } else if (this.m_ExcludeModelsComboBox.getSelectedIndex() == 1) {
                this.applyTestTimeFilters();
            } else if (this.m_ExcludeModelsComboBox.getSelectedIndex() == 2) {
                this.applyFileSizeFilters();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (jTabbedPane.getSelectedComponent().equals(this) && this.m_ListUpdatePending) {
            this.updateDefaultList();
            this.m_ListUpdatePending = false;
        }
    }

    public void applyTrainTimeFilters() {
        Pattern[] patternArray = new Pattern[this.m_LargeTrainTimeModels.length];
        for (int i = 0; i < this.m_LargeTrainTimeModels.length; ++i) {
            patternArray[i] = Pattern.compile(this.m_LargeTrainTimeModels[i]);
        }
        this.applyFilters(patternArray);
    }

    public void applyTestTimeFilters() {
        Pattern[] patternArray = new Pattern[this.m_LargeTestTimeModels.length];
        for (int i = 0; i < this.m_LargeTestTimeModels.length; ++i) {
            patternArray[i] = Pattern.compile(this.m_LargeTestTimeModels[i]);
        }
        this.applyFilters(patternArray);
    }

    public void applyFileSizeFilters() {
        Pattern[] patternArray = new Pattern[this.m_LargeFileSizeModels.length];
        for (int i = 0; i < this.m_LargeFileSizeModels.length; ++i) {
            patternArray[i] = Pattern.compile(this.m_LargeFileSizeModels[i]);
        }
        this.applyFilters(patternArray);
    }

    public void applyFilters(Pattern[] patternArray) {
        ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        Vector<EnsembleLibraryModel> vector = new Vector<EnsembleLibraryModel>();
        Iterator iterator = sortedListModel.iterator();
        block0: while (iterator.hasNext()) {
            EnsembleLibraryModel ensembleLibraryModel = (EnsembleLibraryModel)iterator.next();
            for (int i = 0; i < patternArray.length; ++i) {
                if (!patternArray[i].matcher(ensembleLibraryModel.getStringRepresentation()).matches()) continue;
                vector.add(ensembleLibraryModel);
                continue block0;
            }
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            sortedListModel.removeElement(iterator.next());
        }
    }

    public static String getPackageName() {
        return EnsembleSelectionLibrary.class.toString().replaceAll("class ", "").replaceAll("EnsembleSelectionLibrary", "").replaceAll("\\.", "/");
    }

    static {
        try {
            System.out.println("package name: " + DefaultModelsPanel.getPackageName());
            DEFAULT_PROPERTIES = Utils.readProperties(DefaultModelsPanel.getPackageName() + PROPERTY_FILE);
            Enumeration<?> enumeration = DEFAULT_PROPERTIES.propertyNames();
            if (!enumeration.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the generic object editor");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the default models\npanel.\n", "DefaultProperties", 0);
        }
    }
}

