/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.HashSet;
import java.util.Set;

public class BasicLocker
extends Locker {
    private Long ownedLock;
    private Set<Long> ownedLockSet;
    private boolean lockingRequired;

    protected BasicLocker(EnvironmentImpl env) {
        super(env, false, false, 0L);
    }

    public static BasicLocker createBasicLocker(EnvironmentImpl env) throws DatabaseException {
        BasicLocker ret = null;
        try {
            ret = new BasicLocker(env);
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    protected BasicLocker(EnvironmentImpl env, boolean noWait) {
        super(env, false, noWait, 0L);
    }

    public static BasicLocker createBasicLocker(EnvironmentImpl env, boolean noWait) throws DatabaseException {
        BasicLocker ret = null;
        try {
            ret = new BasicLocker(env, noWait);
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    protected long generateId(TxnManager txnManager, long ignore) {
        return -1L;
    }

    protected void checkState(boolean ignoreCalledByAbort) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws DatabaseException {
        boolean useNoWait;
        BasicLocker basicLocker = this;
        synchronized (basicLocker) {
            this.checkState(false);
        }
        long timeout = 0L;
        boolean bl = useNoWait = noWait || this.defaultNoWait;
        if (!useNoWait) {
            BasicLocker basicLocker2 = this;
            synchronized (basicLocker2) {
                timeout = this.getLockTimeout();
            }
        }
        LockGrantType grant = this.lockManager.lock(nodeId, this, lockType, timeout, useNoWait, database);
        return new LockResult(grant, null);
    }

    public Locker getWriteOwnerLocker(long nodeId) throws DatabaseException {
        return this.lockManager.getWriteOwnerLocker(nodeId);
    }

    public boolean isTransactional() {
        return false;
    }

    public boolean isSerializableIsolation() {
        return false;
    }

    public boolean isReadCommittedIsolation() {
        return false;
    }

    public Txn getTxnLocker() {
        return null;
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        throw EnvironmentFailureException.unexpectedState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNonTxnLocks() throws DatabaseException {
        if (this.ownedLock != null) {
            this.lockManager.release(this.ownedLock, this);
            this.ownedLock = null;
        }
        if (this.ownedLockSet != null) {
            for (Long nid : this.ownedLockSet) {
                this.lockManager.release(nid, this);
            }
            this.ownedLockSet.clear();
        }
        BasicLocker basicLocker = this;
        synchronized (basicLocker) {
            if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                this.envImpl.addToCompressorQueue(this.deleteInfo.values(), false);
                this.deleteInfo.clear();
            }
        }
    }

    public void nonTxnOperationEnd() throws DatabaseException {
        this.operationEnd(true);
    }

    public void operationEnd(boolean operationOK) throws DatabaseException {
        this.releaseNonTxnLocks();
        this.close();
    }

    public void setHandleLockOwner(boolean operationOK, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (dbHandle != null) {
            if (operationOK && !dbIsClosing) {
                this.transferHandleLockToHandle(dbHandle);
            } else {
                this.envImpl.getDbTree().releaseDb(DbInternal.getDatabaseImpl(dbHandle));
            }
            this.unregisterHandle(dbHandle);
        }
    }

    public void registerCursor(CursorImpl cursor) {
        this.lockingRequired = cursor.isInternalDbCursor();
    }

    public void unRegisterCursor(CursorImpl cursor) {
    }

    public boolean lockingRequired() {
        return this.lockingRequired;
    }

    public long getAbortLsn(long nodeId) {
        return -1L;
    }

    public WriteLockInfo getWriteLockInfo(long nodeId) {
        return WriteLockInfo.basicWriteLockInfo;
    }

    public void markDeleteAtTxnEnd(DatabaseImpl db, boolean deleteAtCommit) throws DatabaseException {
        if (deleteAtCommit) {
            db.startAndFinishDelete();
        } else {
            this.envImpl.getDbTree().releaseDb(db);
        }
    }

    protected void addLock(Long nodeId, LockType type, LockGrantType grantStatus) {
        if (this.ownedLock != null && this.ownedLock.equals(nodeId) || this.ownedLockSet != null && this.ownedLockSet.contains(nodeId)) {
            return;
        }
        if (this.ownedLock == null) {
            this.ownedLock = nodeId;
        } else {
            if (this.ownedLockSet == null) {
                this.ownedLockSet = new HashSet<Long>();
            }
            this.ownedLockSet.add(nodeId);
        }
    }

    void removeLock(long nodeId) {
        if (this.ownedLock != null && this.ownedLock == nodeId) {
            this.ownedLock = null;
        } else if (this.ownedLockSet != null) {
            this.ownedLockSet.remove(nodeId);
        }
    }

    public boolean createdNode(long nodeId) {
        return false;
    }

    void moveWriteToReadLock(long nodeId, Lock lock) {
    }

    public StatGroup collectStats() throws DatabaseException {
        Lock l;
        StatGroup stats = new StatGroup("Locker lock counts", "Read and write locks held by this locker");
        IntStat nReadLocks = new IntStat(stats, LockStatDefinition.LOCK_READ_LOCKS);
        IntStat nWriteLocks = new IntStat(stats, LockStatDefinition.LOCK_WRITE_LOCKS);
        if (this.ownedLock != null && (l = this.lockManager.lookupLock(this.ownedLock)) != null) {
            if (l.isOwnedWriteLock(this)) {
                nWriteLocks.increment();
            } else {
                nReadLocks.increment();
            }
        }
        if (this.ownedLockSet != null) {
            for (Long nid : this.ownedLockSet) {
                Lock l2 = this.lockManager.lookupLock(nid);
                if (l2 == null) continue;
                if (l2.isOwnedWriteLock(this)) {
                    nWriteLocks.increment();
                    continue;
                }
                nReadLocks.increment();
            }
        }
        return stats;
    }
}

