/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.rep.vlsn.GhostBucket;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class VLSNBucket {
    private static final int VERSION = 1;
    private final long fileNumber;
    private final int stride;
    protected VLSN firstVLSN = VLSN.NULL_VLSN;
    protected VLSN lastVLSN = VLSN.NULL_VLSN;
    private long lastLsn = -1L;
    private TruncateableList<Integer> fileOffsets;
    private int maxMappings;
    private int maxDistance;
    private static final int NO_OFFSET = 0;
    boolean dirty;
    private boolean closed = false;

    VLSNBucket(long fileNumber, int stride, int maxMappings, int maxDistance, VLSN firstVLSN) {
        this.fileNumber = fileNumber;
        this.stride = stride;
        this.maxMappings = maxMappings;
        this.maxDistance = maxDistance;
        this.firstVLSN = firstVLSN;
        this.lastVLSN = firstVLSN;
        this.fileOffsets = new TruncateableList();
        this.fileOffsets.add(0, 0);
    }

    private VLSNBucket(TupleInput ti) {
        this.fileNumber = ti.readPackedLong();
        this.stride = ti.readPackedInt();
        this.firstVLSN = new VLSN(ti.readPackedLong());
        this.lastVLSN = new VLSN(ti.readPackedLong());
        this.lastLsn = ti.readPackedLong();
        int size = ti.readPackedInt();
        this.fileOffsets = new TruncateableList(size);
        for (int i = 0; i < size; ++i) {
            this.fileOffsets.add(i, DbLsn.getFileOffsetAsInt(ti.readUnsignedInt()));
        }
    }

    synchronized boolean put(VLSN vlsn, long lsn) {
        if (this.closed) {
            return false;
        }
        if (!this.belongs(vlsn, lsn)) {
            return false;
        }
        if (this.isModulo(vlsn)) {
            int listLen;
            int index = this.getIndex(vlsn);
            if (index < (listLen = this.fileOffsets.size())) {
                this.fileOffsets.set(index, DbLsn.getFileOffsetAsInt(lsn));
            } else if (index == listLen) {
                this.fileOffsets.add(DbLsn.getFileOffsetAsInt(lsn));
            } else {
                for (int i = listLen; i < index; ++i) {
                    this.fileOffsets.add(0);
                }
                this.fileOffsets.add(DbLsn.getFileOffsetAsInt(lsn));
            }
            this.dirty = true;
        }
        if (this.lastVLSN.compareTo(vlsn) < 0 || this.lastLsn == -1L) {
            this.lastVLSN = vlsn;
            this.lastLsn = lsn;
            this.dirty = true;
        }
        return true;
    }

    private boolean isModulo(VLSN vlsn) {
        return (vlsn.getSequence() - this.firstVLSN.getSequence()) % (long)this.stride == 0L;
    }

    private int getIndex(VLSN vlsn) {
        assert (this.isModulo(vlsn)) : "Don't call getIndex on non-modulo VLSN " + vlsn + " bucket=" + this;
        return (int)((vlsn.getSequence() - this.firstVLSN.getSequence()) / (long)this.stride);
    }

    private boolean belongs(VLSN vlsn, long lsn) {
        assert (vlsn.compareTo(this.firstVLSN) >= 0) : "firstVLSN = " + this.firstVLSN + " should not be greater than " + vlsn;
        if (DbLsn.getFileNumber(lsn) != this.fileNumber) {
            return false;
        }
        if (this.emptyInternal()) {
            return true;
        }
        if (this.lastVLSN.compareTo(vlsn) > 0) {
            return true;
        }
        boolean onStrideBoundary = this.isModulo(vlsn);
        if (onStrideBoundary && this.fileOffsets.size() >= this.maxMappings) {
            return false;
        }
        if (onStrideBoundary && this.getIndex(vlsn) == this.fileOffsets.size() || this.lastVLSN.compareTo(vlsn) < 0) {
            int lastOffset = (Integer)this.fileOffsets.get(this.fileOffsets.size() - 1);
            if (DbLsn.getFileOffset(lsn) - DbLsn.convertIntFileOffsetToLong(lastOffset) > (long)this.maxDistance) {
                return false;
            }
        }
        return true;
    }

    synchronized boolean owns(VLSN vlsn) {
        if (vlsn.equals(VLSN.NULL_VLSN)) {
            return false;
        }
        if (this.firstVLSN.equals(VLSN.NULL_VLSN)) {
            return false;
        }
        return this.firstVLSN.compareTo(vlsn) <= 0 && this.lastVLSN.compareTo(vlsn) >= 0;
    }

    synchronized VLSN getFirst() {
        return this.firstVLSN;
    }

    synchronized VLSN getLast() {
        return this.lastVLSN;
    }

    long getLTEFileNumber() {
        return this.fileNumber;
    }

    synchronized boolean empty() {
        return this.emptyInternal();
    }

    private boolean emptyInternal() {
        return this.firstVLSN.equals(this.lastVLSN) && this.lastLsn == -1L;
    }

    boolean follows(VLSN vlsn) {
        return this.firstVLSN.compareTo(vlsn) > 0;
    }

    boolean precedes(VLSN vlsn) {
        return !this.lastVLSN.equals(VLSN.NULL_VLSN) && this.lastVLSN.compareTo(vlsn) < 0;
    }

    synchronized long getGTELsn(VLSN vlsn) {
        if (this.lastVLSN.equals(vlsn)) {
            return this.lastLsn;
        }
        int index = this.firstVLSN.compareTo(vlsn) >= 0 ? 0 : this.getGTEIndex(vlsn);
        if (index < 0) {
            throw EnvironmentFailureException.unexpectedState("index=" + index + " vlsn=" + vlsn + " bucket=" + this);
        }
        if (index >= this.fileOffsets.size()) {
            return this.lastLsn;
        }
        int useIndex = this.findPopulatedIndex(index, true);
        int offset = (Integer)this.fileOffsets.get(useIndex);
        return offset == 0 ? this.lastLsn : DbLsn.makeLsn(this.fileNumber, offset);
    }

    private int getGTEIndex(VLSN vlsn) {
        long diff = vlsn.getSequence() - this.firstVLSN.getSequence();
        return (int)((diff + (long)(this.stride - 1)) / (long)this.stride);
    }

    private int findPopulatedIndex(int startIndex, boolean forward) {
        if (forward) {
            for (int i = startIndex; i < this.fileOffsets.size(); ++i) {
                if ((Integer)this.fileOffsets.get(i) == 0) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i >= 0; --i) {
                if ((Integer)this.fileOffsets.get(i) == 0) continue;
                return i;
            }
        }
        return startIndex;
    }

    synchronized long getLTELsn(VLSN vlsn) {
        if (this.lastVLSN.compareTo(vlsn) <= 0) {
            return this.lastLsn;
        }
        long diff = vlsn.getSequence() - this.firstVLSN.getSequence();
        int index = (int)(diff / (long)this.stride);
        if (index >= this.fileOffsets.size()) {
            index = this.fileOffsets.size() - 1;
        }
        int useIndex = this.findPopulatedIndex(index, false);
        int offset = (Integer)this.fileOffsets.get(useIndex);
        assert (offset != 0) : "bucket should always have a non-null first offset. vlsn= " + vlsn + " bucket=" + this;
        return DbLsn.makeLsn(this.fileNumber, offset);
    }

    public synchronized long getLsn(VLSN vlsn) {
        assert (this.owns(vlsn)) : "vlsn=" + vlsn + " " + this;
        if (this.lastVLSN.equals(vlsn)) {
            return this.lastLsn;
        }
        if (!this.isModulo(vlsn)) {
            return -1L;
        }
        int index = this.getIndex(vlsn);
        if (index >= this.fileOffsets.size()) {
            return -1L;
        }
        int offset = (Integer)this.fileOffsets.get(index);
        if (offset == 0) {
            return -1L;
        }
        return DbLsn.makeLsn(this.fileNumber, offset);
    }

    synchronized long getLastLsn() {
        return this.lastLsn;
    }

    VLSNBucket removeFromHead(EnvironmentImpl envImpl, VLSN lastDuplicate) throws IOException {
        int lastOffset;
        if (this.empty()) {
            return null;
        }
        if (lastDuplicate.compareTo(this.firstVLSN) < 0) {
            return null;
        }
        if (this.lastVLSN.compareTo(lastDuplicate) <= 0) {
            this.fileOffsets = null;
            this.firstVLSN = VLSN.NULL_VLSN;
            this.lastVLSN = VLSN.NULL_VLSN;
            this.lastLsn = -1L;
            return null;
        }
        VLSN indexVLSN = this.firstVLSN;
        int newFirstIndex = -1;
        for (int i = 0; i < this.fileOffsets.size(); ++i) {
            if (indexVLSN.compareTo(lastDuplicate) > 0 && (Integer)this.fileOffsets.get(i) != 0) {
                newFirstIndex = i;
                break;
            }
            indexVLSN = new VLSN(indexVLSN.getSequence() + (long)this.stride);
        }
        VLSNBucket remainder = null;
        if (newFirstIndex == -1) {
            lastOffset = (Integer)this.fileOffsets.get(this.fileOffsets.size() - 1);
            this.fileOffsets = new TruncateableList();
            this.fileOffsets.add(DbLsn.getFileOffsetAsInt(this.lastLsn));
            this.firstVLSN = this.lastVLSN;
        } else {
            assert (newFirstIndex > 0);
            lastOffset = (Integer)this.fileOffsets.get(newFirstIndex - 1);
            TruncateableList newFileOffsets = new TruncateableList(this.fileOffsets.subList(newFirstIndex, this.fileOffsets.size()));
            this.fileOffsets = newFileOffsets;
            this.firstVLSN = new VLSN((long)(newFirstIndex * this.stride) + this.firstVLSN.getSequence());
        }
        if (!this.firstVLSN.equals(lastDuplicate.getNext())) {
            long scanStart = DbLsn.makeLsn(this.fileNumber, lastOffset);
            remainder = this.scanForNewBucket(envImpl, lastDuplicate.getNext(), this.firstVLSN.getPrev(), scanStart);
        }
        this.dirty = true;
        return remainder;
    }

    private VLSNBucket scanForNewBucket(EnvironmentImpl envImpl, VLSN first, VLSN last, long startLsn) throws IOException {
        VLSNBucket newBucket = new VLSNBucket(this.fileNumber, this.stride, this.maxMappings, this.maxDistance, first);
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_MAX_SIZE);
        NewBucketReader scanner = new NewBucketReader(newBucket, envImpl, readBufferSize, first, last, startLsn);
        while (!scanner.isDone() && scanner.readNextEntry()) {
        }
        assert (scanner.isDone());
        return newBucket;
    }

    void removeFromTail(VLSN startOfDelete, long prevLsn) {
        if (this.empty()) {
            return;
        }
        if (this.lastVLSN.compareTo(startOfDelete) < 0) {
            return;
        }
        if (this.firstVLSN.compareTo(startOfDelete) >= 0) {
            this.lastVLSN = this.firstVLSN;
            this.lastLsn = -1L;
            this.fileOffsets.clear();
            return;
        }
        int deleteIndex = this.getGTEIndex(startOfDelete);
        if (prevLsn == -1L) {
            assert (deleteIndex != 0) : "startOfDelete=" + startOfDelete + " bucket=" + this;
            int lastPopulatedIndex = this.findPopulatedIndex(deleteIndex - 1, false);
            if (lastPopulatedIndex != deleteIndex - 1) {
                deleteIndex = lastPopulatedIndex + 1;
            }
        }
        this.fileOffsets.truncate(deleteIndex);
        if (prevLsn == -1L) {
            this.lastVLSN = new VLSN((long)((this.fileOffsets.size() - 1) * this.stride) + this.firstVLSN.getSequence());
            Integer lastOffset = (Integer)this.fileOffsets.get(this.fileOffsets.size() - 1);
            assert (lastOffset != null);
            this.lastLsn = DbLsn.makeLsn(this.fileNumber, lastOffset);
        } else {
            this.lastVLSN = startOfDelete.getPrev();
            this.lastLsn = prevLsn;
        }
        this.dirty = true;
    }

    int getNumOffsets() {
        return this.fileOffsets.size();
    }

    void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeToDatabase(EnvironmentImpl envImpl, DatabaseImpl bucketDbImpl, Txn txn) {
        if (!this.dirty) {
            return;
        }
        Cursor c = null;
        try {
            c = DbInternal.makeCursor(bucketDbImpl, txn, CursorConfig.DEFAULT);
            this.writeToDatabase(envImpl, c);
            Object var6_5 = null;
            if (c == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (c == null) throw throwable;
            c.close();
            throw throwable;
        }
        c.close();
    }

    void writeToDatabase(EnvironmentImpl envImpl, Cursor cursor) {
        if (!this.dirty) {
            return;
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        LongBinding.longToEntry(this.firstVLSN.getSequence(), key);
        VLSNBucketBinding bucketBinding = new VLSNBucketBinding();
        bucketBinding.objectToEntry(this, data);
        OperationStatus status = cursor.put(key, data);
        if (status != OperationStatus.SUCCESS) {
            throw EnvironmentFailureException.unexpectedState(envImpl, "Unable to write VLSNBucket for file " + this.fileNumber + " status=" + (Object)((Object)status));
        }
        this.dirty = false;
    }

    public static VLSNBucket readFromDatabase(DatabaseEntry data) {
        VLSNBucketBinding mapperBinding = new VLSNBucketBinding();
        VLSNBucket bucket = (VLSNBucket)mapperBinding.entryToObject(data);
        return bucket;
    }

    void fillDataEntry(DatabaseEntry data) {
        VLSNBucketBinding binding = new VLSNBucketBinding();
        binding.objectToEntry(this, data);
    }

    public String toString() {
        return String.format("<VLSNBucket fileNum=%d(0x%x) numOffsets=%d stride=%d firstVLSN=%s lastVLSN=%s lastLsn=%s/>", this.fileNumber, this.fileNumber, this.fileOffsets == null ? 0 : this.fileOffsets.size(), this.stride, this.firstVLSN, this.lastVLSN, DbLsn.getNoFormatString(this.lastLsn));
    }

    public void dump(PrintStream out) {
        if (this.fileOffsets == null) {
            return;
        }
        long vlsnVal = this.firstVLSN.getSequence();
        int newlineCounter = 0;
        for (Integer offset : this.fileOffsets) {
            out.printf(" [%d 0x%x]", vlsnVal, DbLsn.convertIntFileOffsetToLong(offset));
            vlsnVal += (long)this.stride;
            if (++newlineCounter <= 6) continue;
            out.println("\n");
            newlineCounter = 0;
        }
        out.printf("\n---------Last: VLSN=%s LSN=%s", this.lastVLSN, DbLsn.getNoFormatString(this.lastLsn));
    }

    boolean isGhost() {
        return false;
    }

    void writeToTupleOutput(TupleOutput to) {
        to.writePackedLong(this.fileNumber);
        to.writePackedInt(this.stride);
        to.writePackedLong(this.firstVLSN.getSequence());
        to.writePackedLong(this.lastVLSN.getSequence());
        to.writePackedLong(this.lastLsn);
        to.writePackedInt(this.fileOffsets.size());
        for (Integer offset : this.fileOffsets) {
            to.writeUnsignedInt(DbLsn.convertIntFileOffsetToLong(offset));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TruncateableList<T>
    extends ArrayList<T> {
        TruncateableList() {
        }

        TruncateableList(int capacity) {
            super(capacity);
        }

        TruncateableList(List<T> list) {
            super(list);
        }

        void truncate(int fromIndex) {
            this.removeRange(fromIndex, this.size());
        }
    }

    private static class NewBucketReader
    extends FileReader {
        private final VLSNBucket remainderBucket;
        private boolean done = false;
        private final VLSN first;
        private final VLSN last;

        public NewBucketReader(VLSNBucket remainderBucket, EnvironmentImpl envImpl, int readBufferSize, VLSN first, VLSN last, long startLsn) {
            super(envImpl, readBufferSize, true, startLsn, null, -1L, -1L);
            this.remainderBucket = remainderBucket;
            this.first = first;
            this.last = last;
        }

        protected boolean isTargetEntry() {
            return !this.currentEntryHeader.isInvisible() && this.entryIsReplicated() && this.currentEntryHeader.getVLSN().compareTo(this.first) >= 0;
        }

        protected boolean processEntry(ByteBuffer entryBuffer) {
            if (this.currentEntryHeader.getVLSN().compareTo(this.last) > 0) {
                this.done = true;
            } else {
                this.remainderBucket.put(this.currentEntryHeader.getVLSN(), this.getLastLsn());
            }
            entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
            return true;
        }

        boolean isDone() {
            return this.done;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VLSNBucketBinding
    extends TupleBinding<VLSNBucket> {
        private VLSNBucketBinding() {
        }

        @Override
        public VLSNBucket entryToObject(TupleInput ti) {
            int onDiskVersion = ti.readPackedInt();
            if (onDiskVersion != 1) {
                throw EnvironmentFailureException.unexpectedState("Don't expect version diff on_disk=" + onDiskVersion + " source=" + 1);
            }
            boolean isGhost = ti.readBoolean();
            VLSNBucket bucket = null;
            bucket = isGhost ? GhostBucket.makeNewInstance(ti) : new VLSNBucket(ti);
            return bucket;
        }

        @Override
        public void objectToEntry(VLSNBucket bucket, TupleOutput to) {
            to.writePackedInt(1);
            to.writeBoolean(bucket.isGhost());
            bucket.writeToTupleOutput(to);
        }
    }
}

