/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.spi.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CollectionStringReaderExtractor<V extends Collection>
implements MultivaluedParameterExtractor {
    final StringReader sr;
    final String parameter;
    final String defaultStringValue;

    protected CollectionStringReaderExtractor(StringReader sr, String parameter, String defaultStringValue) {
        this.sr = sr;
        this.parameter = parameter;
        this.defaultStringValue = defaultStringValue;
        Object defaultValue = defaultStringValue != null ? sr.fromString(defaultStringValue) : null;
    }

    @Override
    public String getName() {
        return this.parameter;
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultStringValue;
    }

    @Override
    public Object extract(MultivaluedMap<String, String> parameters) {
        List stringList = (List)parameters.get((Object)this.parameter);
        if (stringList != null) {
            V valueList = this.getInstance();
            for (String v : stringList) {
                valueList.add(v.length() == 0 ? null : (Object)this.sr.fromString(v));
            }
            return valueList;
        }
        if (this.defaultStringValue != null) {
            V valueList = this.getInstance();
            valueList.add(this.sr.fromString(this.defaultStringValue));
            return valueList;
        }
        return this.getInstance();
    }

    protected abstract V getInstance();

    static MultivaluedParameterExtractor getInstance(Class c, StringReader sr, String parameter, String defaultValueString) {
        if (List.class == c) {
            return new ListValueOf(sr, parameter, defaultValueString);
        }
        if (Set.class == c) {
            return new SetValueOf(sr, parameter, defaultValueString);
        }
        if (SortedSet.class == c) {
            return new SortedSetValueOf(sr, parameter, defaultValueString);
        }
        throw new RuntimeException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SortedSetValueOf
    extends CollectionStringReaderExtractor<SortedSet> {
        SortedSetValueOf(StringReader sr, String parameter, String defaultValueString) {
            super(sr, parameter, defaultValueString);
        }

        @Override
        protected SortedSet getInstance() {
            return new TreeSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetValueOf
    extends CollectionStringReaderExtractor<Set> {
        SetValueOf(StringReader sr, String parameter, String defaultValueString) {
            super(sr, parameter, defaultValueString);
        }

        @Override
        protected Set getInstance() {
            return new HashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListValueOf
    extends CollectionStringReaderExtractor<List> {
        ListValueOf(StringReader sr, String parameter, String defaultValueString) {
            super(sr, parameter, defaultValueString);
        }

        @Override
        protected List getInstance() {
            return new ArrayList();
        }
    }
}

