package csl.tools.profiling;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class CslTimer {

	private String						name;
	private long						startTime, stopTime;
	private long						totalTime	= 0;
	private boolean						started		= false;
	private int							count		= 0;
	private int							recCalls	= 0;

	static List<CslTimer>				timers		= new Vector<CslTimer>();
	static HashMap<String, CslTimer>	name2Timer	= new HashMap<String, CslTimer>();

	public CslTimer(String n) {

		name = n;
		timers.add(this);
		name2Timer.put(n, this);
	}

	public void start() {

		if (started) {
			/**
			 * nothing
			 */
			count++;
			recCalls++;
			return;
		}
		count++;
		started = true;
		startTime = System.currentTimeMillis();
	}

	public void stop() {

		if (!started) {
			System.err.println("Timer not started");
			return;
		}
		if (recCalls == 0) {
			started = false;
			stopTime = System.currentTimeMillis();
			totalTime += stopTime - startTime;
		} else
			recCalls--;
	}

	public void reset() {

		started = false;
		totalTime = 0;
		count = 0;
	}

	public static CslTimer named(String n) {

		// for (EdsTimer timer : timers)
		// if (timer.name.equals(n))
		// return timer;

		CslTimer timer = name2Timer.get(n);
		if (timer != null)
			return timer;

		timer = new CslTimer(n);
		return timer;
	}

	public void show() {

		if (started) {
			System.out.print ("Timer not stopped  ");
		}
		System.out.println((started ? "* [" + recCalls + "] " : "") + "Timer (" + name + ") = " + totalTime + " (" + count
				+ ")");
	}

	private void show(PrintStream log) {

		if (started) {
			System.err.println("Timer not stopped");
		}
		log.println((started ? "* [" + recCalls + "] " : "") + "Timer (" + name + ") = " + totalTime + " (" + count
				+ ")");
	}

	public static void resetAll() {

		for (CslTimer t : timers)
			t.reset();
	}

	public static void showAll() {

		for (CslTimer t : timers)
			t.show();
	}

	public static void showAll(PrintStream log) {

		for (CslTimer t : timers)
			t.show(log);
	}

	public static void showAndReset() {

		showAll();
		resetAll();
	}

	public String getName() {

		return name;
	}

	public long getTotalTime() {

		return totalTime;
	}

	public int getCount() {

		return count;
	}

	public boolean getStarted() {

		return started;
	}

	@Override
	public String toString() {

		return name;
	}
}
