package csl.tools.experiments;

public class ThreadDecorator extends Thread {

	private Runnable	delegate;
	private boolean		stopASAP	= false;
	private ThreadPool	pool;

	public ThreadDecorator(ThreadPool threadPool) {

		this.pool = threadPool;
		start();
	}

	@Override
	public void run() {

		while (true) {
			if (stopASAP) {
				return;
			}
			try {
				if (delegate == null)
					synchronized (this) {
						wait();
					}
				if (delegate == null)
					return;
				delegate.run();
				delegate = null;
				pool.frees(this);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	public void stopASAP() {

		stopASAP = true;
		synchronized (this) {
			notify();
		}
	}

	public void setDelegate(Runnable runnable) {

		delegate = runnable;
		synchronized (this) {
			notify();
		}
	}
}
