package csl.tools.csv;

import java.util.ArrayList;
import java.util.List;

public abstract class ColFilter {

	abstract public boolean acceptString(String cell);

	abstract public boolean acceptDouble(Double cell);

	abstract public boolean acceptInteger(Integer cell);

	/**
	 * Applies this filter. Side-effect: the contents of the CsvExplorer is
	 * modified (no undo implemented).
	 */
	public void applyToString(CsvExplorer csv, int colIndex) {

		List<String> list = csv.colString(colIndex);
		List<Integer> rowsToRemove = new ArrayList<Integer>(list.size());
		int row = 0;
		for (String cell : list)
			if (!acceptString(cell))
				rowsToRemove.add(row);
		csv.removeRows(rowsToRemove);
	}

	public void applyToDouble(CsvExplorer csv, int colIndex) {

		List<Double> list = csv.colDouble(colIndex);
		List<Integer> rowsToRemove = new ArrayList<Integer>(list.size());
		int row = 0;
		for (Double cell : list)
			if (!acceptDouble(cell))
				rowsToRemove.add(row);
		csv.removeRows(rowsToRemove);
	}

	public void applyToInteger(CsvExplorer csv, int colIndex) {

		List<Integer> list = csv.colInt(colIndex);
		List<Integer> rowsToRemove = new ArrayList<Integer>(list.size());
		int row = 0;
		for (Integer cell : list) {
			if (!acceptInteger(cell))
				rowsToRemove.add(row);
			row++;
		}
		csv.removeRows(rowsToRemove);
	}

	public void applyToString(CsvExplorer csv, String colName) {

		applyToString(csv, csv.indexOfColNamed(colName));
	}

	public void applyToDouble(CsvExplorer csv, String colName) {

		applyToDouble(csv, csv.indexOfColNamed(colName));
	}

	public void applyToInteger(CsvExplorer csv, String colName) {

		applyToInteger(csv, csv.indexOfColNamed(colName));
	}
}
