package csl.tools.algos;

import java.util.List;
import java.util.Vector;

public class Vertex {

	final public String name;

	final public int index;

	final boolean isBattery;

	final public List<Edge> edges = new Vector<Edge>();

	private boolean loaded = false;

	final public String imgFileName;

	public Vertex(final String name, final int index, boolean bat) {
		super();
		this.name = name;
		this.index = index;
		this.isBattery = bat;
		this.imgFileName = "default.jpg";
	}

	public Vertex(final String name, String imgFileName, final int index,
			boolean bat) {
		super();
		this.name = name;
		this.index = index;
		this.isBattery = bat;
		this.imgFileName = imgFileName;
	}

	public Vertex(String string, int i) {
		this(string, i, false);
	}

	@Override
	public String toString() {
		return "[" + name + "]";
	}

	public boolean isLoaded() {
		return loaded;
	}

	public void setIsLoaded(boolean b) {
		loaded = b;
	}

	public Edge edgeTo(Vertex to) {
		for (Edge e : edges)
			if (e.getEnd() == to)
				return e;
		return null;
	}

	public Vertex copy() {

		return new Vertex(name, index, isBattery);
	}
}
